/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.reactor;

import java.io.Closeable;
import java.io.IOException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hc.core5.function.Callback;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.io.Closer;
import org.apache.hc.core5.reactor.IOReactor;
import org.apache.hc.core5.reactor.IOReactorStatus;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;

abstract class AbstractSingleCoreIOReactor
implements IOReactor {
    private final Callback<Exception> exceptionCallback;
    private final AtomicReference<IOReactorStatus> status;
    private final AtomicBoolean terminated;
    private final Condition condition;
    private final ReentrantLock lock;
    final Selector selector;

    AbstractSingleCoreIOReactor(Callback<Exception> callback) {
        this.exceptionCallback = callback;
        this.status = new AtomicReference<IOReactorStatus>(IOReactorStatus.INACTIVE);
        this.terminated = new AtomicBoolean();
        try {
            this.selector = Selector.open();
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Unexpected failure opening I/O selector", iOException);
        }
        this.lock = new ReentrantLock();
        this.condition = this.lock.newCondition();
    }

    @Override
    public final IOReactorStatus getStatus() {
        return this.status.get();
    }

    void logException(Exception exception) {
        if (this.exceptionCallback != null) {
            this.exceptionCallback.execute(exception);
        }
    }

    abstract void doExecute() throws IOException;

    abstract void doTerminate() throws IOException;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() {
        if (!this.status.compareAndSet(IOReactorStatus.INACTIVE, IOReactorStatus.ACTIVE)) return;
        try {
            this.doExecute();
            return;
        }
        catch (ClosedSelectorException closedSelectorException) {
            try {
                this.doTerminate();
                return;
            }
            catch (Exception exception) {
                this.logException(exception);
                return;
            }
            finally {
                this.close(CloseMode.IMMEDIATE);
            }
        }
        catch (Exception exception) {
            this.logException(exception);
            return;
        }
        finally {
            try {
                this.doTerminate();
            }
            catch (Exception exception) {
                this.logException(exception);
            }
            finally {
                this.close(CloseMode.IMMEDIATE);
            }
        }
    }

    @Override
    public final void awaitShutdown(TimeValue timeValue) throws InterruptedException {
        Args.notNull(timeValue, "Wait time");
        long l2 = System.currentTimeMillis() + timeValue.toMilliseconds();
        long l3 = timeValue.toMilliseconds();
        this.lock.lock();
        try {
            while (this.status.get().compareTo(IOReactorStatus.SHUT_DOWN) < 0) {
                this.condition.await(l3, TimeUnit.MILLISECONDS);
                l3 = l2 - System.currentTimeMillis();
                if (l3 > 0L) continue;
                return;
            }
            return;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public final void initiateShutdown() {
        if (this.status.compareAndSet(IOReactorStatus.INACTIVE, IOReactorStatus.SHUT_DOWN)) {
            this.lock.lock();
            try {
                this.condition.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        } else if (this.status.compareAndSet(IOReactorStatus.ACTIVE, IOReactorStatus.SHUTTING_DOWN)) {
            this.selector.wakeup();
        }
    }

    @Override
    public final void close(CloseMode closeMode) {
        this.close(closeMode, Timeout.ofSeconds(5L));
    }

    public void close(CloseMode object, Timeout object2) {
        if (object == CloseMode.GRACEFUL) {
            this.initiateShutdown();
            try {
                this.awaitShutdown((TimeValue)object2);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
        this.status.set(IOReactorStatus.SHUT_DOWN);
        if (this.terminated.compareAndSet(false, true)) {
            try {
                object = this.selector.keys();
                object = object.iterator();
                while (object.hasNext()) {
                    object2 = (SelectionKey)object.next();
                    try {
                        Closer.close((Closeable)((SelectionKey)object2).attachment());
                    }
                    catch (IOException iOException) {
                        this.logException(iOException);
                    }
                    ((SelectionKey)object2).channel().close();
                }
                this.selector.close();
            }
            catch (Exception exception) {
                this.logException(exception);
            }
        }
        this.lock.lock();
        try {
            this.condition.signalAll();
            return;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public final void close() {
        this.close(CloseMode.GRACEFUL);
    }

    public String toString() {
        return super.toString() + " [status=" + this.status + "]";
    }
}

