/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.reactor;

import java.io.IOException;
import java.net.SocketAddress;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.apache.hc.core5.concurrent.DefaultThreadFactory;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.function.Callback;
import org.apache.hc.core5.function.Decorator;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.reactor.AbstractIOReactorBase;
import org.apache.hc.core5.reactor.ChannelEntry;
import org.apache.hc.core5.reactor.ConnectionAcceptor;
import org.apache.hc.core5.reactor.IOEventHandlerFactory;
import org.apache.hc.core5.reactor.IOReactor;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.reactor.IOReactorShutdownException;
import org.apache.hc.core5.reactor.IOReactorStatus;
import org.apache.hc.core5.reactor.IOReactorWorker;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.reactor.IOSessionListener;
import org.apache.hc.core5.reactor.IOWorkers;
import org.apache.hc.core5.reactor.IOWorkers$Selector;
import org.apache.hc.core5.reactor.ListenerEndpoint;
import org.apache.hc.core5.reactor.MultiCoreIOReactor;
import org.apache.hc.core5.reactor.SingleCoreIOReactor;
import org.apache.hc.core5.reactor.SingleCoreListeningIOReactor;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.TimeValue;

public class DefaultListeningIOReactor
extends AbstractIOReactorBase
implements ConnectionAcceptor {
    private static final ThreadFactory DISPATCH_THREAD_FACTORY = new DefaultThreadFactory("I/O server dispatch", true);
    private static final ThreadFactory LISTENER_THREAD_FACTORY = new DefaultThreadFactory("I/O listener", true);
    private final int workerCount;
    private final SingleCoreIOReactor[] workers;
    private final SingleCoreListeningIOReactor listener;
    private final MultiCoreIOReactor ioReactor;
    private final IOWorkers$Selector workerSelector;

    public DefaultListeningIOReactor(IOEventHandlerFactory iOEventHandlerFactory, IOReactorConfig iOReactorConfig, ThreadFactory threadFactory, ThreadFactory threadFactory2, Decorator<IOSession> decorator, Callback<Exception> callback, IOSessionListener iOSessionListener, Callback<IOSession> callback2) {
        Args.notNull(iOEventHandlerFactory, "Event handler factory");
        this.workerCount = iOReactorConfig != null ? iOReactorConfig.getIoThreadCount() : IOReactorConfig.DEFAULT.getIoThreadCount();
        this.workers = new SingleCoreIOReactor[this.workerCount];
        Thread[] threadArray = new Thread[this.workerCount + 1];
        for (int i2 = 0; i2 < this.workers.length; ++i2) {
            SingleCoreIOReactor singleCoreIOReactor;
            this.workers[i2] = singleCoreIOReactor = new SingleCoreIOReactor(callback, iOEventHandlerFactory, iOReactorConfig != null ? iOReactorConfig : IOReactorConfig.DEFAULT, decorator, iOSessionListener, callback2);
            threadArray[i2 + 1] = (threadFactory != null ? threadFactory : DISPATCH_THREAD_FACTORY).newThread(new IOReactorWorker(singleCoreIOReactor));
        }
        IOReactor[] iOReactorArray = new IOReactor[this.workerCount + 1];
        System.arraycopy(this.workers, 0, iOReactorArray, 1, this.workerCount);
        this.listener = new SingleCoreListeningIOReactor(callback, iOReactorConfig, this::enqueueChannel);
        iOReactorArray[0] = this.listener;
        threadArray[0] = (threadFactory2 != null ? threadFactory2 : LISTENER_THREAD_FACTORY).newThread(new IOReactorWorker(this.listener));
        this.ioReactor = new MultiCoreIOReactor(iOReactorArray, threadArray);
        this.workerSelector = IOWorkers.newSelector(this.workers);
    }

    public DefaultListeningIOReactor(IOEventHandlerFactory iOEventHandlerFactory, IOReactorConfig iOReactorConfig, Callback<IOSession> callback) {
        this(iOEventHandlerFactory, iOReactorConfig, null, null, null, null, null, callback);
    }

    public DefaultListeningIOReactor(IOEventHandlerFactory iOEventHandlerFactory) {
        this(iOEventHandlerFactory, null, null);
    }

    @Override
    public void start() {
        this.ioReactor.start();
    }

    @Override
    public Future<ListenerEndpoint> listen(SocketAddress socketAddress, Object object, FutureCallback<ListenerEndpoint> futureCallback) {
        return this.listener.listen(socketAddress, object, futureCallback);
    }

    @Override
    public Future<ListenerEndpoint> listen(SocketAddress socketAddress, FutureCallback<ListenerEndpoint> futureCallback) {
        return this.listen(socketAddress, null, futureCallback);
    }

    public Future<ListenerEndpoint> listen(SocketAddress socketAddress) {
        return this.listen(socketAddress, null);
    }

    @Override
    public Set<ListenerEndpoint> getEndpoints() {
        return this.listener.getEndpoints();
    }

    @Override
    public void pause() throws IOException {
        this.listener.pause();
    }

    @Override
    public void resume() throws IOException {
        this.listener.resume();
    }

    @Override
    public IOReactorStatus getStatus() {
        return this.ioReactor.getStatus();
    }

    @Override
    IOWorkers$Selector getWorkerSelector() {
        return this.workerSelector;
    }

    private void enqueueChannel(ChannelEntry channelEntry) {
        try {
            this.workerSelector.next().enqueueChannel(channelEntry);
            return;
        }
        catch (IOReactorShutdownException iOReactorShutdownException) {
            this.initiateShutdown();
            return;
        }
    }

    @Override
    public void initiateShutdown() {
        this.ioReactor.initiateShutdown();
    }

    @Override
    public void awaitShutdown(TimeValue timeValue) throws InterruptedException {
        this.ioReactor.awaitShutdown(timeValue);
    }

    @Override
    public void close(CloseMode closeMode) {
        this.ioReactor.close(closeMode);
    }

    @Override
    public void close() throws IOException {
        this.ioReactor.close();
    }
}

