/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.reactor;

import java.net.SocketAddress;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.reactor.IOReactorConfig$Builder;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public final class IOReactorConfig {
    public static final IOReactorConfig DEFAULT = new IOReactorConfig$Builder().build();
    private final TimeValue selectInterval;
    private final int ioThreadCount;
    private final Timeout soTimeout;
    private final boolean soReuseAddress;
    private final TimeValue soLinger;
    private final boolean soKeepAlive;
    private final boolean tcpNoDelay;
    private final int trafficClass;
    private final int sndBufSize;
    private final int rcvBufSize;
    private final int backlogSize;
    private final int tcpKeepIdle;
    private final int tcpKeepInterval;
    private final int tcpKeepCount;
    private final SocketAddress socksProxyAddress;
    private final String socksProxyUsername;
    private final String socksProxyPassword;

    IOReactorConfig(TimeValue timeValue, int n2, Timeout timeout, boolean bl2, TimeValue timeValue2, boolean bl3, boolean bl4, int n3, int n4, int n5, int n6, int n7, int n8, int n9, SocketAddress socketAddress, String string, String string2) {
        this.selectInterval = timeValue;
        this.ioThreadCount = n2;
        this.soTimeout = timeout;
        this.soReuseAddress = bl2;
        this.soLinger = timeValue2;
        this.soKeepAlive = bl3;
        this.tcpNoDelay = bl4;
        this.trafficClass = n3;
        this.sndBufSize = n4;
        this.rcvBufSize = n5;
        this.backlogSize = n6;
        this.tcpKeepIdle = n7;
        this.tcpKeepInterval = n8;
        this.tcpKeepCount = n9;
        this.socksProxyAddress = socketAddress;
        this.socksProxyUsername = string;
        this.socksProxyPassword = string2;
    }

    public final TimeValue getSelectInterval() {
        return this.selectInterval;
    }

    public final int getIoThreadCount() {
        return this.ioThreadCount;
    }

    public final Timeout getSoTimeout() {
        return this.soTimeout;
    }

    public final boolean isSoReuseAddress() {
        return this.soReuseAddress;
    }

    public final TimeValue getSoLinger() {
        return this.soLinger;
    }

    public final boolean isSoKeepAlive() {
        return this.soKeepAlive;
    }

    @Deprecated
    public final boolean isSoKeepalive() {
        return this.soKeepAlive;
    }

    public final boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public final int getTrafficClass() {
        return this.trafficClass;
    }

    public final int getSndBufSize() {
        return this.sndBufSize;
    }

    public final int getRcvBufSize() {
        return this.rcvBufSize;
    }

    public final int getBacklogSize() {
        return this.backlogSize;
    }

    public final int getTcpKeepIdle() {
        return this.tcpKeepIdle;
    }

    public final int getTcpKeepInterval() {
        return this.tcpKeepInterval;
    }

    public final int getTcpKeepCount() {
        return this.tcpKeepCount;
    }

    public final SocketAddress getSocksProxyAddress() {
        return this.socksProxyAddress;
    }

    public final String getSocksProxyUsername() {
        return this.socksProxyUsername;
    }

    public final String getSocksProxyPassword() {
        return this.socksProxyPassword;
    }

    public static IOReactorConfig$Builder custom() {
        return new IOReactorConfig$Builder();
    }

    public static IOReactorConfig$Builder copy(IOReactorConfig iOReactorConfig) {
        Args.notNull(iOReactorConfig, "I/O reactor config");
        return new IOReactorConfig$Builder().setSelectInterval(iOReactorConfig.getSelectInterval()).setIoThreadCount(iOReactorConfig.getIoThreadCount()).setSoTimeout(iOReactorConfig.getSoTimeout()).setSoReuseAddress(iOReactorConfig.isSoReuseAddress()).setSoLinger(iOReactorConfig.getSoLinger()).setSoKeepAlive(iOReactorConfig.isSoKeepAlive()).setTcpNoDelay(iOReactorConfig.isTcpNoDelay()).setSndBufSize(iOReactorConfig.getSndBufSize()).setRcvBufSize(iOReactorConfig.getRcvBufSize()).setBacklogSize(iOReactorConfig.getBacklogSize()).setTcpKeepIdle(iOReactorConfig.getTcpKeepIdle()).setTcpKeepInterval(iOReactorConfig.getTcpKeepInterval()).setTcpKeepCount(iOReactorConfig.getTcpKeepCount()).setSocksProxyAddress(iOReactorConfig.getSocksProxyAddress()).setSocksProxyUsername(iOReactorConfig.getSocksProxyUsername()).setSocksProxyPassword(iOReactorConfig.getSocksProxyPassword());
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[selectInterval=").append(this.selectInterval).append(", ioThreadCount=").append(this.ioThreadCount).append(", soTimeout=").append(this.soTimeout).append(", soReuseAddress=").append(this.soReuseAddress).append(", soLinger=").append(this.soLinger).append(", soKeepAlive=").append(this.soKeepAlive).append(", tcpNoDelay=").append(this.tcpNoDelay).append(", trafficClass=").append(this.trafficClass).append(", sndBufSize=").append(this.sndBufSize).append(", rcvBufSize=").append(this.rcvBufSize).append(", backlogSize=").append(this.backlogSize).append(", socksProxyAddress=").append(this.socksProxyAddress).append("]");
        return stringBuilder.toString();
    }
}

