/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.reactor;

import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.io.ModalCloseable;
import org.apache.hc.core5.util.Timeout;

abstract class InternalChannel
implements ModalCloseable {
    InternalChannel() {
    }

    abstract void onIOEvent(int var1) throws IOException;

    abstract void onTimeout(Timeout var1) throws IOException;

    abstract void onException(Exception var1);

    abstract Timeout getTimeout();

    abstract long getLastEventTime();

    final void handleIOEvent(int n2) {
        try {
            this.onIOEvent(n2);
            return;
        }
        catch (CancelledKeyException cancelledKeyException) {
            this.close(CloseMode.GRACEFUL);
            return;
        }
        catch (Exception exception) {
            this.onException(exception);
            this.close(CloseMode.GRACEFUL);
            return;
        }
    }

    final boolean checkTimeout(long l2) {
        Timeout timeout = this.getTimeout();
        if (!timeout.isDisabled()) {
            long l3 = timeout.toMilliseconds();
            long l4 = this.getLastEventTime() + l3;
            if (l2 > l4) {
                try {
                    this.onTimeout(timeout);
                }
                catch (CancelledKeyException cancelledKeyException) {
                    this.close(CloseMode.GRACEFUL);
                }
                catch (Exception exception) {
                    this.onException(exception);
                    this.close(CloseMode.GRACEFUL);
                }
                return false;
            }
        }
        return true;
    }
}

