/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.reactor;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.io.Closer;
import org.apache.hc.core5.reactor.IOReactor;
import org.apache.hc.core5.reactor.IOReactorStatus;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;

class MultiCoreIOReactor
implements IOReactor {
    private final IOReactor[] ioReactors;
    private final Thread[] threads;
    private final AtomicReference<IOReactorStatus> status;
    private final AtomicBoolean terminated;

    MultiCoreIOReactor(IOReactor[] iOReactorArray, Thread[] threadArray) {
        this.ioReactors = (IOReactor[])iOReactorArray.clone();
        this.threads = (Thread[])threadArray.clone();
        this.status = new AtomicReference<IOReactorStatus>(IOReactorStatus.INACTIVE);
        this.terminated = new AtomicBoolean();
    }

    @Override
    public IOReactorStatus getStatus() {
        return this.status.get();
    }

    public final void start() {
        if (this.status.compareAndSet(IOReactorStatus.INACTIVE, IOReactorStatus.ACTIVE)) {
            for (int i2 = 0; i2 < this.threads.length; ++i2) {
                this.threads[i2].start();
            }
        }
    }

    @Override
    public final void initiateShutdown() {
        if (this.status.compareAndSet(IOReactorStatus.INACTIVE, IOReactorStatus.SHUT_DOWN) || this.status.compareAndSet(IOReactorStatus.ACTIVE, IOReactorStatus.SHUTTING_DOWN)) {
            for (int i2 = 0; i2 < this.ioReactors.length; ++i2) {
                IOReactor iOReactor = this.ioReactors[i2];
                iOReactor.initiateShutdown();
            }
        }
    }

    @Override
    public final void awaitShutdown(TimeValue timeValue) throws InterruptedException {
        Object object;
        int n2;
        Args.notNull(timeValue, "Wait time");
        long l2 = System.currentTimeMillis() + timeValue.toMilliseconds();
        long l3 = timeValue.toMilliseconds();
        for (n2 = 0; n2 < this.ioReactors.length; ++n2) {
            object = this.ioReactors[n2];
            if (object.getStatus().compareTo(IOReactorStatus.SHUT_DOWN) >= 0) continue;
            object.awaitShutdown(TimeValue.of(l3, TimeUnit.MILLISECONDS));
            l3 = l2 - System.currentTimeMillis();
            if (l3 > 0L) continue;
            return;
        }
        for (n2 = 0; n2 < this.threads.length; ++n2) {
            object = this.threads[n2];
            ((Thread)object).join(l3);
            l3 = l2 - System.currentTimeMillis();
            if (l3 > 0L) continue;
            return;
        }
    }

    @Override
    public final void close(CloseMode closeMode) {
        this.close(closeMode, Timeout.ofSeconds(5L));
    }

    public void close(CloseMode closeMode, Timeout timeout) {
        if (closeMode == CloseMode.GRACEFUL) {
            this.initiateShutdown();
            try {
                this.awaitShutdown(timeout);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
        this.status.set(IOReactorStatus.SHUT_DOWN);
        if (this.terminated.compareAndSet(false, true)) {
            int n2;
            for (n2 = 0; n2 < this.ioReactors.length; ++n2) {
                Closer.close(this.ioReactors[n2], CloseMode.IMMEDIATE);
            }
            for (n2 = 0; n2 < this.threads.length; ++n2) {
                this.threads[n2].interrupt();
            }
        }
    }

    @Override
    public final void close() {
        this.close(CloseMode.GRACEFUL);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [status=" + this.status + "]";
    }
}

