/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.reactor;

import java.io.IOException;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.SocketAddress;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hc.core5.concurrent.BasicFuture;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.function.Callback;
import org.apache.hc.core5.io.Closer;
import org.apache.hc.core5.reactor.AbstractSingleCoreIOReactor;
import org.apache.hc.core5.reactor.ChannelEntry;
import org.apache.hc.core5.reactor.ConnectionAcceptor;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.reactor.IOReactorShutdownException;
import org.apache.hc.core5.reactor.IOReactorStatus;
import org.apache.hc.core5.reactor.ListenerEndpoint;
import org.apache.hc.core5.reactor.ListenerEndpointImpl;
import org.apache.hc.core5.reactor.ListenerEndpointRequest;

class SingleCoreListeningIOReactor
extends AbstractSingleCoreIOReactor
implements ConnectionAcceptor {
    private final IOReactorConfig reactorConfig;
    private final Callback<ChannelEntry> callback;
    private final Queue<ListenerEndpointRequest> requestQueue;
    private final ConcurrentMap<ListenerEndpointImpl, Boolean> endpoints;
    private final AtomicBoolean paused;
    private final long selectTimeoutMillis;

    SingleCoreListeningIOReactor(Callback<Exception> callback, IOReactorConfig iOReactorConfig, Callback<ChannelEntry> callback2) {
        super(callback);
        this.reactorConfig = iOReactorConfig != null ? iOReactorConfig : IOReactorConfig.DEFAULT;
        this.callback = callback2;
        this.requestQueue = new ConcurrentLinkedQueue<ListenerEndpointRequest>();
        this.endpoints = new ConcurrentHashMap<ListenerEndpointImpl, Boolean>();
        this.paused = new AtomicBoolean();
        this.selectTimeoutMillis = this.reactorConfig.getSelectInterval().toMilliseconds();
    }

    @Override
    void doTerminate() {
        ListenerEndpointRequest listenerEndpointRequest;
        while ((listenerEndpointRequest = this.requestQueue.poll()) != null) {
            listenerEndpointRequest.cancel();
        }
    }

    @Override
    protected final void doExecute() throws IOException {
        while (!Thread.currentThread().isInterrupted() && this.getStatus() == IOReactorStatus.ACTIVE) {
            int n2 = this.selector.select(this.selectTimeoutMillis);
            if (this.getStatus() != IOReactorStatus.ACTIVE) break;
            this.processEvents(n2);
        }
    }

    private void processEvents(int n2) throws IOException {
        if (!this.paused.get()) {
            this.processSessionRequests();
        }
        if (n2 > 0) {
            Set<SelectionKey> set = this.selector.selectedKeys();
            for (SelectionKey selectionKey : set) {
                this.processEvent(selectionKey);
            }
            set.clear();
        }
    }

    private void processEvent(SelectionKey selectionKey) throws IOException {
        try {
            if (selectionKey.isAcceptable()) {
                SocketChannel socketChannel;
                ServerSocketChannel serverSocketChannel = (ServerSocketChannel)selectionKey.channel();
                while ((socketChannel = serverSocketChannel.accept()) != null) {
                    ListenerEndpointRequest listenerEndpointRequest = (ListenerEndpointRequest)selectionKey.attachment();
                    this.callback.execute(new ChannelEntry(socketChannel, listenerEndpointRequest.attachment));
                }
            }
            return;
        }
        catch (CancelledKeyException cancelledKeyException) {
            ListenerEndpointImpl listenerEndpointImpl = (ListenerEndpointImpl)selectionKey.attachment();
            this.endpoints.remove(listenerEndpointImpl);
            selectionKey.attach(null);
            return;
        }
    }

    @Override
    public Future<ListenerEndpoint> listen(SocketAddress socketAddress, Object object, FutureCallback<ListenerEndpoint> object2) {
        if (this.getStatus().compareTo(IOReactorStatus.SHUTTING_DOWN) >= 0) {
            throw new IOReactorShutdownException("I/O reactor has been shut down");
        }
        object2 = new BasicFuture<ListenerEndpoint>((FutureCallback<ListenerEndpoint>)object2);
        this.requestQueue.add(new ListenerEndpointRequest(socketAddress, object, (BasicFuture<ListenerEndpoint>)object2));
        this.selector.wakeup();
        return object2;
    }

    @Override
    public Future<ListenerEndpoint> listen(SocketAddress socketAddress, FutureCallback<ListenerEndpoint> futureCallback) {
        return this.listen(socketAddress, null, futureCallback);
    }

    private void processSessionRequests() throws IOException {
        ListenerEndpointRequest listenerEndpointRequest;
        while ((listenerEndpointRequest = this.requestQueue.poll()) != null) {
            if (listenerEndpointRequest.isCancelled()) continue;
            Object object = listenerEndpointRequest.address;
            ServerSocketChannel serverSocketChannel = ServerSocketChannel.open();
            try {
                ServerSocket serverSocket = serverSocketChannel.socket();
                serverSocket.setReuseAddress(this.reactorConfig.isSoReuseAddress());
                if (this.reactorConfig.getRcvBufSize() > 0) {
                    serverSocket.setReceiveBufferSize(this.reactorConfig.getRcvBufSize());
                }
                serverSocketChannel.configureBlocking(false);
                try {
                    serverSocket.bind((SocketAddress)object, this.reactorConfig.getBacklogSize());
                }
                catch (BindException bindException) {
                    object = new BindException(String.format("Socket bind failure for socket %s, address=%s, BacklogSize=%d: %s", serverSocket, object, this.reactorConfig.getBacklogSize(), bindException));
                    ((Throwable)object).setStackTrace(bindException.getStackTrace());
                    throw object;
                }
                SelectionKey selectionKey = serverSocketChannel.register(this.selector, 16);
                selectionKey.attach(listenerEndpointRequest);
                object = new ListenerEndpointImpl(selectionKey, listenerEndpointRequest.attachment, serverSocket.getLocalSocketAddress());
                this.endpoints.put((ListenerEndpointImpl)object, Boolean.TRUE);
                listenerEndpointRequest.completed((ListenerEndpoint)object);
            }
            catch (IOException iOException) {
                Closer.closeQuietly(serverSocketChannel);
                listenerEndpointRequest.failed(iOException);
            }
        }
    }

    @Override
    public Set<ListenerEndpoint> getEndpoints() {
        HashSet<ListenerEndpoint> hashSet = new HashSet<ListenerEndpoint>();
        Iterator iterator = this.endpoints.keySet().iterator();
        while (iterator.hasNext()) {
            ListenerEndpoint listenerEndpoint = (ListenerEndpoint)iterator.next();
            if (!listenerEndpoint.isClosed()) {
                hashSet.add(listenerEndpoint);
                continue;
            }
            iterator.remove();
        }
        return hashSet;
    }

    @Override
    public void pause() throws IOException {
        if (this.paused.compareAndSet(false, true)) {
            Iterator iterator = this.endpoints.keySet().iterator();
            while (iterator.hasNext()) {
                ListenerEndpointImpl listenerEndpointImpl = (ListenerEndpointImpl)iterator.next();
                if (!listenerEndpointImpl.isClosed()) {
                    listenerEndpointImpl.close();
                    this.requestQueue.add(new ListenerEndpointRequest(listenerEndpointImpl.address, listenerEndpointImpl.attachment, null));
                }
                iterator.remove();
            }
        }
    }

    @Override
    public void resume() throws IOException {
        if (this.paused.compareAndSet(true, false)) {
            this.selector.wakeup();
        }
    }
}

