/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.reactor.ssl;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.function.Callback;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.net.NamedEndpoint;
import org.apache.hc.core5.reactor.Command;
import org.apache.hc.core5.reactor.Command$Priority;
import org.apache.hc.core5.reactor.IOEventHandler;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.reactor.IOSession$Status;
import org.apache.hc.core5.reactor.ssl.SSLBufferMode;
import org.apache.hc.core5.reactor.ssl.SSLIOSession$1;
import org.apache.hc.core5.reactor.ssl.SSLIOSession$2;
import org.apache.hc.core5.reactor.ssl.SSLIOSession$TLSHandShakeState;
import org.apache.hc.core5.reactor.ssl.SSLManagedBuffer;
import org.apache.hc.core5.reactor.ssl.SSLMode;
import org.apache.hc.core5.reactor.ssl.SSLSessionInitializer;
import org.apache.hc.core5.reactor.ssl.SSLSessionVerifier;
import org.apache.hc.core5.reactor.ssl.TlsDetails;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.Asserts;
import org.apache.hc.core5.util.Timeout;

@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
@Internal
public class SSLIOSession
implements IOSession {
    private static final ByteBuffer EMPTY_BUFFER = ByteBuffer.allocate(0);
    private final NamedEndpoint targetEndpoint;
    private final IOSession session;
    private final SSLEngine sslEngine;
    private final SSLManagedBuffer inEncrypted;
    private final SSLManagedBuffer outEncrypted;
    private final SSLManagedBuffer inPlain;
    private final SSLSessionInitializer initializer;
    private final SSLSessionVerifier verifier;
    private final Callback<SSLIOSession> sessionStartCallback;
    private final Callback<SSLIOSession> sessionEndCallback;
    private final AtomicReference<FutureCallback<SSLSession>> handshakeCallbackRef;
    private final Timeout handshakeTimeout;
    private final SSLMode sslMode;
    private final AtomicInteger outboundClosedCount;
    private final AtomicReference<SSLIOSession$TLSHandShakeState> handshakeStateRef;
    private final IOEventHandler internalEventHandler;
    private final int packetBufferSize;
    private int appEventMask;
    private volatile boolean endOfStream;
    private volatile IOSession$Status status = IOSession$Status.ACTIVE;
    private volatile Timeout socketTimeout;
    private volatile TlsDetails tlsDetails;
    private volatile boolean appClosed;

    public SSLIOSession(NamedEndpoint namedEndpoint, IOSession iOSession, SSLMode sSLMode, SSLContext sSLContext, SSLBufferMode sSLBufferMode, SSLSessionInitializer sSLSessionInitializer, SSLSessionVerifier sSLSessionVerifier, Callback<SSLIOSession> callback, Callback<SSLIOSession> callback2, Timeout timeout) {
        this(namedEndpoint, iOSession, sSLMode, sSLContext, sSLBufferMode, sSLSessionInitializer, sSLSessionVerifier, timeout, callback, callback2, null);
    }

    public SSLIOSession(NamedEndpoint object, IOSession iOSession, SSLMode sSLMode, SSLContext sSLContext, SSLBufferMode sSLBufferMode, SSLSessionInitializer sSLSessionInitializer, SSLSessionVerifier sSLSessionVerifier, Timeout timeout, Callback<SSLIOSession> callback, Callback<SSLIOSession> callback2, FutureCallback<SSLSession> futureCallback) {
        Args.notNull(iOSession, "IO session");
        Args.notNull(sSLContext, "SSL context");
        this.targetEndpoint = object;
        this.session = iOSession;
        this.sslMode = sSLMode;
        this.initializer = sSLSessionInitializer;
        this.verifier = sSLSessionVerifier;
        this.sessionStartCallback = callback;
        this.sessionEndCallback = callback2;
        this.handshakeCallbackRef = new AtomicReference<FutureCallback<SSLSession>>(futureCallback);
        this.appEventMask = iOSession.getEventMask();
        this.sslEngine = this.sslMode == SSLMode.CLIENT && object != null ? sSLContext.createSSLEngine(object.getHostName(), object.getPort()) : sSLContext.createSSLEngine();
        object = this.sslEngine.getSession();
        this.packetBufferSize = object.getPacketBufferSize();
        this.inEncrypted = SSLManagedBuffer.create(sSLBufferMode, this.packetBufferSize);
        this.outEncrypted = SSLManagedBuffer.create(sSLBufferMode, this.packetBufferSize);
        int n2 = object.getApplicationBufferSize();
        this.inPlain = SSLManagedBuffer.create(sSLBufferMode, n2);
        this.outboundClosedCount = new AtomicInteger(0);
        this.handshakeStateRef = new AtomicReference<SSLIOSession$TLSHandShakeState>(SSLIOSession$TLSHandShakeState.READY);
        this.handshakeTimeout = timeout;
        this.internalEventHandler = new SSLIOSession$1(this, timeout, iOSession);
    }

    private IOEventHandler ensureHandler() {
        IOEventHandler iOEventHandler = this.session.getHandler();
        Asserts.notNull(iOEventHandler, "IO event handler");
        return iOEventHandler;
    }

    @Override
    public IOEventHandler getHandler() {
        return this.internalEventHandler;
    }

    public void beginHandshake(IOSession iOSession) throws IOException {
        if (this.handshakeStateRef.compareAndSet(SSLIOSession$TLSHandShakeState.READY, SSLIOSession$TLSHandShakeState.INITIALIZED)) {
            this.initialize(iOSession);
        }
    }

    private void initialize(IOSession iOSession) throws IOException {
        this.socketTimeout = this.session.getSocketTimeout();
        if (this.handshakeTimeout != null) {
            this.session.setSocketTimeout(this.handshakeTimeout);
        }
        this.session.getLock().lock();
        try {
            if (this.status.compareTo(IOSession$Status.CLOSING) >= 0) {
                return;
            }
            switch (this.sslMode) {
                case CLIENT: {
                    this.sslEngine.setUseClientMode(true);
                    break;
                }
                case SERVER: {
                    this.sslEngine.setUseClientMode(false);
                }
            }
            if (this.initializer != null) {
                this.initializer.initialize(this.targetEndpoint, this.sslEngine);
            }
            this.handshakeStateRef.set(SSLIOSession$TLSHandShakeState.HANDSHAKING);
            this.sslEngine.beginHandshake();
            this.inEncrypted.release();
            this.outEncrypted.release();
            this.doHandshake(iOSession);
            this.updateEventMask();
            return;
        }
        finally {
            this.session.getLock().unlock();
        }
    }

    private SSLException convert(RuntimeException runtimeException) {
        Throwable throwable = runtimeException.getCause();
        if (throwable == null) {
            throwable = runtimeException;
        }
        return new SSLException(throwable);
    }

    private SSLEngineResult doWrap(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws SSLException {
        try {
            return this.sslEngine.wrap(byteBuffer, byteBuffer2);
        }
        catch (RuntimeException runtimeException) {
            throw this.convert(runtimeException);
        }
    }

    private SSLEngineResult doUnwrap(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws SSLException {
        try {
            return this.sslEngine.unwrap(byteBuffer, byteBuffer2);
        }
        catch (RuntimeException runtimeException) {
            throw this.convert(runtimeException);
        }
    }

    private void doRunTask() {
        Runnable runnable = this.sslEngine.getDelegatedTask();
        if (runnable != null) {
            runnable.run();
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void doHandshake(IOSession var1_1) throws IOException {
        var2_4 = true;
        var3_5 = null;
        while (var2_4) {
            var4_7 /* !! */  = this.sslEngine.getHandshakeStatus();
            if (var4_7 /* !! */  == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING && this.outboundClosedCount.get() > 0) {
                var4_7 /* !! */  = SSLEngineResult.HandshakeStatus.NEED_WRAP;
            }
            switch (SSLIOSession$2.$SwitchMap$javax$net$ssl$SSLEngineResult$HandshakeStatus[var4_7 /* !! */ .ordinal()]) {
                case 1: {
                    this.session.getLock().lock();
                    try {
                        var5_8 = this.outEncrypted.acquire();
                        var3_5 = this.doWrap(SSLIOSession.EMPTY_BUFFER, (ByteBuffer)var5_8);
                        if (var3_5.getStatus() == SSLEngineResult.Status.OK && var3_5.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NEED_WRAP) break;
                        var2_4 = false;
                        break;
                    }
                    finally {
                        this.session.getLock().unlock();
                    }
                }
                case 2: {
                    var5_8 = this.inEncrypted.acquire();
                    var3_5 = this.inPlain.acquire();
                    var5_8.flip();
                    try {
                        var3_5 = this.doUnwrap((ByteBuffer)var5_8, (ByteBuffer)var3_5);
                    }
                    finally {
                        var5_8.compact();
                    }
                    try {
                        if (!var5_8.hasRemaining() && var3_5.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                            throw new SSLException("Input buffer is full");
                        }
                    }
                    finally {
                        if (var5_8.position() == 0) {
                            this.inEncrypted.release();
                        }
                    }
                    if (this.status.compareTo(IOSession$Status.CLOSING) >= 0) {
                        this.inPlain.release();
                    }
                    if (var3_5.getStatus() == SSLEngineResult.Status.OK) break;
                    ** GOTO lbl46
                }
                case 3: {
                    this.doRunTask();
                    break;
                }
lbl46:
                // 2 sources

                case 4: {
                    var2_4 = false;
                }
            }
        }
        if (var3_5 != null && var3_5.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED) {
            this.handshakeStateRef.set(SSLIOSession$TLSHandShakeState.COMPLETE);
            this.session.setSocketTimeout(this.socketTimeout);
            if (this.verifier != null) {
                this.tlsDetails = this.verifier.verify(this.targetEndpoint, this.sslEngine);
            }
            if (this.tlsDetails == null) {
                var5_8 = this.sslEngine.getSession();
                try {
                    var4_7 /* !! */  = this.sslEngine.getApplicationProtocol();
                }
                catch (UnsupportedOperationException v0) {
                    var4_7 /* !! */  = "http/1.1";
                }
                this.tlsDetails = new TlsDetails((SSLSession)var5_8, (String)var4_7 /* !! */ );
            }
            this.ensureHandler().connected(var1_1);
            if (this.sessionStartCallback != null) {
                this.sessionStartCallback.execute(this);
            }
            if ((var5_8 = (FutureCallback)this.handshakeCallbackRef.getAndSet(null)) != null) {
                var5_8.completed(this.sslEngine.getSession());
            }
        }
    }

    private void updateEventMask() {
        this.session.getLock().lock();
        try {
            int n2;
            Object object;
            if (this.status == IOSession$Status.ACTIVE && (this.endOfStream || this.sslEngine.isInboundDone())) {
                this.status = IOSession$Status.CLOSING;
                object = this.handshakeCallbackRef.getAndSet(null);
                if (object != null) {
                    object.failed(new SSLHandshakeException("TLS handshake failed"));
                }
            }
            if (this.status == IOSession$Status.CLOSING && !this.outEncrypted.hasData()) {
                this.sslEngine.closeOutbound();
                this.outboundClosedCount.incrementAndGet();
            }
            object = this.sslEngine.getHandshakeStatus();
            if (this.status == IOSession$Status.CLOSING && (object == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING || object == SSLEngineResult.HandshakeStatus.FINISHED) && !this.outEncrypted.hasData() && this.sslEngine.isOutboundDone() && (this.endOfStream || this.sslEngine.isInboundDone()) && this.appClosed) {
                this.status = IOSession$Status.CLOSED;
            }
            if (this.status.compareTo(IOSession$Status.CLOSING) <= 0 && this.endOfStream && object == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                this.status = IOSession$Status.CLOSED;
            }
            if (this.status == IOSession$Status.CLOSED) {
                this.session.close();
                if (this.sessionEndCallback != null) {
                    this.sessionEndCallback.execute(this);
                }
                return;
            }
            if (object == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                this.doRunTask();
            }
            int n3 = n2 = this.session.getEventMask();
            switch (this.sslEngine.getHandshakeStatus()) {
                case NEED_WRAP: {
                    n3 = 5;
                    break;
                }
                case NEED_UNWRAP: {
                    n3 = 1;
                    break;
                }
                case NOT_HANDSHAKING: {
                    n3 = this.appEventMask;
                }
            }
            if (this.endOfStream && !this.inPlain.hasData()) {
                n3 &= 0xFFFFFFFE;
            } else if (this.status == IOSession$Status.CLOSING) {
                n3 |= 1;
            }
            if (this.outEncrypted.hasData()) {
                n3 |= 4;
            }
            if (n2 != n3) {
                this.session.setEventMask(n3);
            }
            return;
        }
        finally {
            this.session.getLock().unlock();
        }
    }

    private int sendEncryptedData() throws IOException {
        this.session.getLock().lock();
        try {
            if (this.status == IOSession$Status.ACTIVE && !this.outEncrypted.hasData()) {
                int n2 = this.session.write(EMPTY_BUFFER);
                return n2;
            }
            ByteBuffer byteBuffer = this.outEncrypted.acquire();
            if (this.status == IOSession$Status.CLOSED) {
                byteBuffer.clear();
            }
            int n3 = 0;
            if (byteBuffer.position() > 0) {
                byteBuffer.flip();
                try {
                    n3 = this.session.write(byteBuffer);
                }
                finally {
                    byteBuffer.compact();
                }
            }
            if (byteBuffer.position() == 0) {
                this.outEncrypted.release();
            }
            return n3;
        }
        finally {
            this.session.getLock().unlock();
        }
    }

    private int receiveEncryptedData() throws IOException {
        if (this.endOfStream) {
            return -1;
        }
        ByteBuffer byteBuffer = this.inEncrypted.acquire();
        int n2 = this.session.read(byteBuffer);
        if (byteBuffer.position() == 0) {
            this.inEncrypted.release();
        }
        if (n2 == -1) {
            this.endOfStream = true;
        }
        return n2;
    }

    private void decryptData(IOSession iOSession) throws IOException {
        Object object = this.sslEngine.getHandshakeStatus();
        if ((object == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING || object == SSLEngineResult.HandshakeStatus.FINISHED) && this.inEncrypted.hasData()) {
            object = this.inEncrypted.acquire();
            ((ByteBuffer)object).flip();
            try {
                while (((Buffer)object).hasRemaining()) {
                    ByteBuffer byteBuffer = this.inPlain.acquire();
                    try {
                        SSLEngineResult sSLEngineResult = this.doUnwrap((ByteBuffer)object, byteBuffer);
                        if (!((Buffer)object).hasRemaining() && sSLEngineResult.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                            throw new SSLException("Unable to complete SSL handshake");
                        }
                        if (this.sslEngine.isInboundDone()) {
                            this.endOfStream = true;
                        }
                        if (byteBuffer.position() > 0) {
                            byteBuffer.flip();
                            try {
                                this.ensureHandler().inputReady(iOSession, byteBuffer.hasRemaining() ? byteBuffer : null);
                            }
                            finally {
                                byteBuffer.clear();
                            }
                        }
                        if (sSLEngineResult.getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW && this.endOfStream) {
                            throw new SSLException("Unable to decrypt incoming data due to unexpected end of stream");
                        }
                        if (sSLEngineResult.getStatus() == SSLEngineResult.Status.OK && (sSLEngineResult.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING || sSLEngineResult.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED)) continue;
                        break;
                    }
                    finally {
                        this.inPlain.release();
                    }
                }
            }
            finally {
                ((ByteBuffer)object).compact();
                if (((Buffer)object).position() == 0) {
                    this.inEncrypted.release();
                }
            }
        }
        if (this.endOfStream && !this.inEncrypted.hasData()) {
            this.ensureHandler().inputReady(iOSession, null);
        }
    }

    private void encryptData(IOSession iOSession) throws IOException {
        boolean bl2;
        this.session.getLock().lock();
        try {
            bl2 = (this.appEventMask & 4) > 0 && this.status.compareTo(IOSession$Status.CLOSED) < 0 && this.sslEngine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
        }
        finally {
            this.session.getLock().unlock();
        }
        if (bl2) {
            this.ensureHandler().outputReady(iOSession);
        }
    }

    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        Args.notNull(byteBuffer, "Byte buffer");
        this.session.getLock().lock();
        try {
            Object object;
            if (this.status != IOSession$Status.ACTIVE) {
                throw new ClosedChannelException();
            }
            if (this.handshakeStateRef.get() == SSLIOSession$TLSHandShakeState.READY) {
                return 0;
            }
            while (true) {
                object = this.outEncrypted.acquire();
                if (((SSLEngineResult)(object = this.doWrap(byteBuffer, (ByteBuffer)object))).getStatus() != SSLEngineResult.Status.BUFFER_OVERFLOW) break;
                this.outEncrypted.ensureWriteable(this.packetBufferSize);
            }
            int n2 = ((SSLEngineResult)object).bytesConsumed();
            return n2;
        }
        finally {
            this.session.getLock().unlock();
        }
    }

    @Override
    public int read(ByteBuffer byteBuffer) {
        if (this.endOfStream) {
            return -1;
        }
        return 0;
    }

    @Override
    public String getId() {
        return this.session.getId();
    }

    @Override
    public Lock getLock() {
        return this.session.getLock();
    }

    @Override
    public void upgrade(IOEventHandler iOEventHandler) {
        this.session.upgrade(iOEventHandler);
    }

    public TlsDetails getTlsDetails() {
        return this.tlsDetails;
    }

    @Override
    public boolean isOpen() {
        return this.status == IOSession$Status.ACTIVE && this.session.isOpen();
    }

    @Override
    public void close() {
        this.close(CloseMode.GRACEFUL);
    }

    @Override
    public void close(CloseMode closeMode) {
        this.session.getLock().lock();
        try {
            this.appClosed = true;
            if (closeMode == CloseMode.GRACEFUL) {
                if (this.status.compareTo(IOSession$Status.CLOSING) >= 0) {
                    return;
                }
                this.status = IOSession$Status.CLOSING;
                if (this.session.getSocketTimeout().isDisabled()) {
                    this.session.setSocketTimeout(Timeout.ofMilliseconds(1000L));
                }
                try {
                    SSLIOSession sSLIOSession = this;
                    sSLIOSession.doHandshake(sSLIOSession);
                    this.sendEncryptedData();
                    this.updateEventMask();
                }
                catch (CancelledKeyException cancelledKeyException) {
                    this.session.close(CloseMode.GRACEFUL);
                }
                catch (Exception exception) {
                    this.session.close(CloseMode.IMMEDIATE);
                }
            } else {
                if (this.status == IOSession$Status.CLOSED) {
                    return;
                }
                this.inEncrypted.release();
                this.outEncrypted.release();
                this.inPlain.release();
                this.status = IOSession$Status.CLOSED;
                this.session.close(closeMode);
            }
            return;
        }
        finally {
            this.session.getLock().unlock();
        }
    }

    @Override
    public IOSession$Status getStatus() {
        return this.status;
    }

    @Override
    public void enqueue(Command command, Command$Priority command$Priority) {
        this.session.getLock().lock();
        try {
            this.session.enqueue(command, command$Priority);
            if (this.status == IOSession$Status.ACTIVE) {
                this.setEvent(4);
            } else {
                command.cancel();
            }
            return;
        }
        finally {
            this.session.getLock().unlock();
        }
    }

    @Override
    public boolean hasCommands() {
        return this.session.hasCommands();
    }

    @Override
    public Command poll() {
        return this.session.poll();
    }

    @Override
    public ByteChannel channel() {
        return this.session.channel();
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.session.getLocalAddress();
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.session.getRemoteAddress();
    }

    @Override
    public int getEventMask() {
        this.session.getLock().lock();
        try {
            int n2 = this.appEventMask;
            return n2;
        }
        finally {
            this.session.getLock().unlock();
        }
    }

    @Override
    public void setEventMask(int n2) {
        this.session.getLock().lock();
        try {
            this.appEventMask = n2;
            this.updateEventMask();
            return;
        }
        finally {
            this.session.getLock().unlock();
        }
    }

    @Override
    public void setEvent(int n2) {
        this.session.getLock().lock();
        try {
            this.appEventMask |= n2;
            this.updateEventMask();
            return;
        }
        finally {
            this.session.getLock().unlock();
        }
    }

    @Override
    public void clearEvent(int n2) {
        this.session.getLock().lock();
        try {
            this.appEventMask &= ~n2;
            this.updateEventMask();
            return;
        }
        finally {
            this.session.getLock().unlock();
        }
    }

    @Override
    public Timeout getSocketTimeout() {
        return this.session.getSocketTimeout();
    }

    @Override
    public void setSocketTimeout(Timeout timeout) {
        this.socketTimeout = timeout;
        if (this.sslEngine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED) {
            this.session.setSocketTimeout(timeout);
        }
    }

    @Override
    public void updateReadTime() {
        this.session.updateReadTime();
    }

    @Override
    public void updateWriteTime() {
        this.session.updateWriteTime();
    }

    @Override
    public long getLastReadTime() {
        return this.session.getLastReadTime();
    }

    @Override
    public long getLastWriteTime() {
        return this.session.getLastWriteTime();
    }

    @Override
    public long getLastEventTime() {
        return this.session.getLastEventTime();
    }

    private static void formatOps(StringBuilder stringBuilder, int n2) {
        if ((n2 & 1) > 0) {
            stringBuilder.append('r');
        }
        if ((n2 & 4) > 0) {
            stringBuilder.append('w');
        }
    }

    public String toString() {
        this.session.getLock().lock();
        try {
            CharSequence charSequence = new StringBuilder();
            charSequence.append(this.session);
            charSequence.append("[");
            charSequence.append((Object)this.status);
            charSequence.append("][");
            SSLIOSession.formatOps(charSequence, this.appEventMask);
            charSequence.append("][");
            charSequence.append((Object)this.sslEngine.getHandshakeStatus());
            if (this.sslEngine.isInboundDone()) {
                charSequence.append("][inbound done][");
            }
            if (this.sslEngine.isOutboundDone()) {
                charSequence.append("][outbound done][");
            }
            if (this.endOfStream) {
                charSequence.append("][EOF][");
            }
            charSequence.append("][");
            charSequence.append(!this.inEncrypted.hasData() ? 0 : this.inEncrypted.acquire().position());
            charSequence.append("][");
            charSequence.append(!this.inPlain.hasData() ? 0 : this.inPlain.acquire().position());
            charSequence.append("][");
            charSequence.append(!this.outEncrypted.hasData() ? 0 : this.outEncrypted.acquire().position());
            charSequence.append("]");
            charSequence = charSequence.toString();
            return charSequence;
        }
        finally {
            this.session.getLock().unlock();
        }
    }

    static /* synthetic */ int access$000(SSLIOSession sSLIOSession) throws IOException {
        return sSLIOSession.receiveEncryptedData();
    }

    static /* synthetic */ void access$100(SSLIOSession sSLIOSession, IOSession iOSession) throws IOException {
        sSLIOSession.doHandshake(iOSession);
    }

    static /* synthetic */ void access$200(SSLIOSession sSLIOSession, IOSession iOSession) throws IOException {
        sSLIOSession.decryptData(iOSession);
    }

    static /* synthetic */ void access$300(SSLIOSession sSLIOSession) {
        sSLIOSession.updateEventMask();
    }

    static /* synthetic */ void access$400(SSLIOSession sSLIOSession, IOSession iOSession) throws IOException {
        sSLIOSession.encryptData(iOSession);
    }

    static /* synthetic */ int access$500(SSLIOSession sSLIOSession) throws IOException {
        return sSLIOSession.sendEncryptedData();
    }

    static /* synthetic */ SSLEngine access$600(SSLIOSession sSLIOSession) {
        return sSLIOSession.sslEngine;
    }

    static /* synthetic */ AtomicReference access$700(SSLIOSession sSLIOSession) {
        return sSLIOSession.handshakeStateRef;
    }

    static /* synthetic */ IOEventHandler access$800(SSLIOSession sSLIOSession) {
        return sSLIOSession.ensureHandler();
    }

    static /* synthetic */ AtomicReference access$900(SSLIOSession sSLIOSession) {
        return sSLIOSession.handshakeCallbackRef;
    }
}

