/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.reactor.ssl;

import java.nio.ByteBuffer;
import org.apache.hc.core5.reactor.ssl.SSLBufferMode;
import org.apache.hc.core5.reactor.ssl.SSLManagedBuffer$DynamicBuffer;
import org.apache.hc.core5.reactor.ssl.SSLManagedBuffer$StaticBuffer;

abstract class SSLManagedBuffer {
    SSLManagedBuffer() {
    }

    abstract ByteBuffer acquire();

    abstract void release();

    abstract boolean isAcquired();

    abstract boolean hasData();

    abstract void ensureWriteable(int var1);

    ByteBuffer ensureWriteable(ByteBuffer byteBuffer, int n2) {
        if (byteBuffer == null) {
            return null;
        }
        if (byteBuffer.remaining() < n2) {
            ByteBuffer byteBuffer2 = ByteBuffer.allocate(byteBuffer.capacity() + (n2 -= byteBuffer.remaining()));
            byteBuffer = byteBuffer.duplicate();
            byteBuffer.flip();
            byteBuffer2.put(byteBuffer);
            return byteBuffer2;
        }
        return byteBuffer;
    }

    static SSLManagedBuffer create(SSLBufferMode sSLBufferMode, int n2) {
        if (sSLBufferMode == SSLBufferMode.DYNAMIC) {
            return new SSLManagedBuffer$DynamicBuffer(n2);
        }
        return new SSLManagedBuffer$StaticBuffer(n2);
    }
}

