/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.ssl;

import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.X509ExtendedKeyManager;
import org.apache.hc.core5.ssl.PrivateKeyDetails;
import org.apache.hc.core5.ssl.PrivateKeyStrategy;

class SSLContextBuilder$KeyManagerDelegate
extends X509ExtendedKeyManager {
    private final X509ExtendedKeyManager keyManager;
    private final PrivateKeyStrategy aliasStrategy;

    SSLContextBuilder$KeyManagerDelegate(X509ExtendedKeyManager x509ExtendedKeyManager, PrivateKeyStrategy privateKeyStrategy) {
        this.keyManager = x509ExtendedKeyManager;
        this.aliasStrategy = privateKeyStrategy;
    }

    @Override
    public String[] getClientAliases(String string, Principal[] principalArray) {
        return this.keyManager.getClientAliases(string, principalArray);
    }

    public Map<String, PrivateKeyDetails> getClientAliasMap(String[] stringArray, Principal[] principalArray) {
        HashMap<String, PrivateKeyDetails> hashMap = new HashMap<String, PrivateKeyDetails>();
        for (String string : stringArray) {
            this.putPrivateKeyDetails(hashMap, string, this.keyManager.getClientAliases(string, principalArray));
        }
        return hashMap;
    }

    public Map<String, PrivateKeyDetails> getServerAliasMap(String string, Principal[] principalArray) {
        HashMap<String, PrivateKeyDetails> hashMap = new HashMap<String, PrivateKeyDetails>();
        this.putPrivateKeyDetails(hashMap, string, this.keyManager.getServerAliases(string, principalArray));
        return hashMap;
    }

    private void putPrivateKeyDetails(Map<String, PrivateKeyDetails> map, String string, String[] stringArray) {
        if (stringArray != null) {
            for (String string2 : stringArray) {
                map.put(string2, new PrivateKeyDetails(string, this.keyManager.getCertificateChain(string2)));
            }
        }
    }

    @Override
    public String chooseClientAlias(String[] object, Principal[] principalArray, Socket socket) {
        object = this.getClientAliasMap((String[])object, principalArray);
        return this.aliasStrategy.chooseAlias((Map<String, PrivateKeyDetails>)object, socket instanceof SSLSocket ? ((SSLSocket)socket).getSSLParameters() : null);
    }

    @Override
    public String[] getServerAliases(String string, Principal[] principalArray) {
        return this.keyManager.getServerAliases(string, principalArray);
    }

    @Override
    public String chooseServerAlias(String object, Principal[] principalArray, Socket socket) {
        object = this.getServerAliasMap((String)object, principalArray);
        return this.aliasStrategy.chooseAlias((Map<String, PrivateKeyDetails>)object, socket instanceof SSLSocket ? ((SSLSocket)socket).getSSLParameters() : null);
    }

    @Override
    public X509Certificate[] getCertificateChain(String string) {
        return this.keyManager.getCertificateChain(string);
    }

    @Override
    public PrivateKey getPrivateKey(String string) {
        return this.keyManager.getPrivateKey(string);
    }

    @Override
    public String chooseEngineClientAlias(String[] object, Principal[] principalArray, SSLEngine sSLEngine) {
        object = this.getClientAliasMap((String[])object, principalArray);
        return this.aliasStrategy.chooseAlias((Map<String, PrivateKeyDetails>)object, sSLEngine.getSSLParameters());
    }

    @Override
    public String chooseEngineServerAlias(String object, Principal[] principalArray, SSLEngine sSLEngine) {
        object = this.getServerAliasMap((String)object, principalArray);
        return this.aliasStrategy.chooseAlias((Map<String, PrivateKeyDetails>)object, sSLEngine.getSSLParameters());
    }
}

