/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.ssl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509TrustManager;
import org.apache.hc.core5.ssl.PrivateKeyStrategy;
import org.apache.hc.core5.ssl.SSLContextBuilder$KeyManagerDelegate;
import org.apache.hc.core5.ssl.SSLContextBuilder$TrustManagerDelegate;
import org.apache.hc.core5.ssl.TrustStrategy;
import org.apache.hc.core5.util.Args;

public class SSLContextBuilder {
    static final String TLS = "TLS";
    private String protocol;
    private final Set<KeyManager> keyManagers;
    private String keyManagerFactoryAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
    private String keyStoreType = KeyStore.getDefaultType();
    private final Set<TrustManager> trustManagers;
    private String trustManagerFactoryAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
    private SecureRandom secureRandom;
    private Provider provider;
    private Provider tsProvider;
    private Provider ksProvider;
    private static final KeyManager[] EMPTY_KEY_MANAGER_ARRAY = new KeyManager[0];
    private static final TrustManager[] EMPTY_TRUST_MANAGER_ARRAY = new TrustManager[0];

    public static SSLContextBuilder create() {
        return new SSLContextBuilder();
    }

    public SSLContextBuilder() {
        this.keyManagers = new LinkedHashSet<KeyManager>();
        this.trustManagers = new LinkedHashSet<TrustManager>();
    }

    public SSLContextBuilder setProtocol(String string) {
        this.protocol = string;
        return this;
    }

    public SSLContextBuilder setProvider(Provider provider) {
        this.provider = provider;
        return this;
    }

    public SSLContextBuilder setProvider(String string) {
        this.provider = Security.getProvider(string);
        return this;
    }

    public SSLContextBuilder setTrustStoreProvider(Provider provider) {
        this.tsProvider = provider;
        return this;
    }

    public SSLContextBuilder setTrustStoreProvider(String string) throws NoSuchProviderException {
        this.tsProvider = this.requireNonNullProvider(string);
        return this;
    }

    public SSLContextBuilder setKeyStoreProvider(Provider provider) {
        this.ksProvider = provider;
        return this;
    }

    public SSLContextBuilder setKeyStoreProvider(String string) throws NoSuchProviderException {
        this.ksProvider = this.requireNonNullProvider(string);
        return this;
    }

    public SSLContextBuilder setKeyStoreType(String string) {
        this.keyStoreType = string;
        return this;
    }

    public SSLContextBuilder setKeyManagerFactoryAlgorithm(String string) {
        this.keyManagerFactoryAlgorithm = string;
        return this;
    }

    public SSLContextBuilder setTrustManagerFactoryAlgorithm(String string) {
        this.trustManagerFactoryAlgorithm = string;
        return this;
    }

    public SSLContextBuilder setSecureRandom(SecureRandom secureRandom) {
        this.secureRandom = secureRandom;
        return this;
    }

    public SSLContextBuilder loadTrustMaterial(KeyStore trustManagerArray, TrustStrategy trustStrategy) throws NoSuchAlgorithmException, KeyStoreException {
        Object object = this.trustManagerFactoryAlgorithm == null ? TrustManagerFactory.getDefaultAlgorithm() : this.trustManagerFactoryAlgorithm;
        object = this.tsProvider == null ? TrustManagerFactory.getInstance((String)object) : TrustManagerFactory.getInstance((String)object, this.tsProvider);
        ((TrustManagerFactory)object).init((KeyStore)trustManagerArray);
        trustManagerArray = ((TrustManagerFactory)object).getTrustManagers();
        if (trustManagerArray != null) {
            if (trustStrategy != null) {
                for (int i2 = 0; i2 < trustManagerArray.length; ++i2) {
                    TrustManager trustManager = trustManagerArray[i2];
                    if (!(trustManager instanceof X509TrustManager)) continue;
                    trustManagerArray[i2] = new SSLContextBuilder$TrustManagerDelegate((X509TrustManager)trustManager, trustStrategy);
                }
            }
            Collections.addAll(this.trustManagers, trustManagerArray);
        }
        return this;
    }

    public SSLContextBuilder loadTrustMaterial(Path path) throws NoSuchAlgorithmException, KeyStoreException, CertificateException, IOException {
        return this.loadTrustMaterial(path, null);
    }

    public SSLContextBuilder loadTrustMaterial(Path path, char[] cArray) throws NoSuchAlgorithmException, KeyStoreException, CertificateException, IOException {
        return this.loadTrustMaterial(path, cArray, null, new OpenOption[0]);
    }

    public SSLContextBuilder loadTrustMaterial(Path path, char[] cArray, TrustStrategy trustStrategy, OpenOption ... openOptionArray) throws NoSuchAlgorithmException, KeyStoreException, CertificateException, IOException {
        Args.notNull(path, "Truststore file");
        SSLContextBuilder sSLContextBuilder = this;
        return sSLContextBuilder.loadTrustMaterial(sSLContextBuilder.loadKeyStore(path, cArray, openOptionArray), trustStrategy);
    }

    public SSLContextBuilder loadTrustMaterial(TrustStrategy trustStrategy) throws NoSuchAlgorithmException, KeyStoreException {
        return this.loadTrustMaterial(null, trustStrategy);
    }

    public SSLContextBuilder loadTrustMaterial(File file, char[] cArray, TrustStrategy trustStrategy) throws NoSuchAlgorithmException, KeyStoreException, CertificateException, IOException {
        Args.notNull(file, "Truststore file");
        return this.loadTrustMaterial(file.toPath(), cArray, trustStrategy, new OpenOption[0]);
    }

    public SSLContextBuilder loadTrustMaterial(File file, char[] cArray) throws NoSuchAlgorithmException, KeyStoreException, CertificateException, IOException {
        return this.loadTrustMaterial(file, cArray, null);
    }

    public SSLContextBuilder loadTrustMaterial(File file) throws NoSuchAlgorithmException, KeyStoreException, CertificateException, IOException {
        return this.loadTrustMaterial(file, null);
    }

    public SSLContextBuilder loadTrustMaterial(URL uRL, char[] cArray, TrustStrategy trustStrategy) throws NoSuchAlgorithmException, KeyStoreException, CertificateException, IOException {
        Args.notNull(uRL, "Truststore URL");
        SSLContextBuilder sSLContextBuilder = this;
        return sSLContextBuilder.loadTrustMaterial(sSLContextBuilder.loadKeyStore(uRL, cArray), trustStrategy);
    }

    public SSLContextBuilder loadTrustMaterial(URL uRL, char[] cArray) throws NoSuchAlgorithmException, KeyStoreException, CertificateException, IOException {
        return this.loadTrustMaterial(uRL, cArray, null);
    }

    public SSLContextBuilder loadKeyMaterial(KeyStore keyManagerArray, char[] cArray, PrivateKeyStrategy privateKeyStrategy) throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException {
        Object object = this.keyManagerFactoryAlgorithm == null ? KeyManagerFactory.getDefaultAlgorithm() : this.keyManagerFactoryAlgorithm;
        object = this.ksProvider == null ? KeyManagerFactory.getInstance((String)object) : KeyManagerFactory.getInstance((String)object, this.ksProvider);
        ((KeyManagerFactory)object).init((KeyStore)keyManagerArray, cArray);
        keyManagerArray = ((KeyManagerFactory)object).getKeyManagers();
        if (keyManagerArray != null) {
            if (privateKeyStrategy != null) {
                for (int i2 = 0; i2 < keyManagerArray.length; ++i2) {
                    object = keyManagerArray[i2];
                    if (!(object instanceof X509ExtendedKeyManager)) continue;
                    keyManagerArray[i2] = new SSLContextBuilder$KeyManagerDelegate((X509ExtendedKeyManager)object, privateKeyStrategy);
                }
            }
            Collections.addAll(this.keyManagers, keyManagerArray);
        }
        return this;
    }

    public SSLContextBuilder loadKeyMaterial(Path path, char[] cArray, char[] cArray2, OpenOption ... openOptionArray) throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException, CertificateException, IOException {
        return this.loadKeyMaterial(path, cArray, cArray2, (PrivateKeyStrategy)null, openOptionArray);
    }

    public SSLContextBuilder loadKeyMaterial(Path path, char[] cArray, char[] cArray2, PrivateKeyStrategy privateKeyStrategy, OpenOption ... openOptionArray) throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException, CertificateException, IOException {
        Args.notNull(path, "Keystore file");
        SSLContextBuilder sSLContextBuilder = this;
        return sSLContextBuilder.loadKeyMaterial(sSLContextBuilder.loadKeyStore(path, cArray, openOptionArray), cArray2, privateKeyStrategy);
    }

    public SSLContextBuilder loadKeyMaterial(KeyStore keyStore, char[] cArray) throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException {
        return this.loadKeyMaterial(keyStore, cArray, null);
    }

    public SSLContextBuilder loadKeyMaterial(File file, char[] cArray, char[] cArray2, PrivateKeyStrategy privateKeyStrategy) throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException, CertificateException, IOException {
        Args.notNull(file, "Keystore file");
        return this.loadKeyMaterial(file.toPath(), cArray, cArray2, privateKeyStrategy, new OpenOption[0]);
    }

    public SSLContextBuilder loadKeyMaterial(File file, char[] cArray, char[] cArray2) throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException, CertificateException, IOException {
        return this.loadKeyMaterial(file, cArray, cArray2, null);
    }

    public SSLContextBuilder loadKeyMaterial(URL uRL, char[] cArray, char[] cArray2, PrivateKeyStrategy privateKeyStrategy) throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException, CertificateException, IOException {
        Args.notNull(uRL, "Keystore URL");
        SSLContextBuilder sSLContextBuilder = this;
        return sSLContextBuilder.loadKeyMaterial(sSLContextBuilder.loadKeyStore(uRL, cArray), cArray2, privateKeyStrategy);
    }

    public SSLContextBuilder loadKeyMaterial(URL uRL, char[] cArray, char[] cArray2) throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException, CertificateException, IOException {
        return this.loadKeyMaterial(uRL, cArray, cArray2, null);
    }

    protected void initSSLContext(SSLContext sSLContext, Collection<KeyManager> collection, Collection<TrustManager> collection2, SecureRandom secureRandom) throws KeyManagementException {
        sSLContext.init(!collection.isEmpty() ? collection.toArray(EMPTY_KEY_MANAGER_ARRAY) : null, !collection2.isEmpty() ? collection2.toArray(EMPTY_TRUST_MANAGER_ARRAY) : null, secureRandom);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private KeyStore loadKeyStore(Path object, char[] object2, OpenOption ... object3) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        Throwable throwable;
        KeyStore keyStore = KeyStore.getInstance(this.keyStoreType);
        object = Files.newInputStream((Path)object, (OpenOption[])throwable);
        throwable = null;
        try {
            keyStore.load((InputStream)object, (char[])object2);
            if (object == null) return keyStore;
        }
        catch (Throwable throwable2) {
            try {
                Throwable throwable3 = throwable2;
                throwable = throwable2;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                if (object == null) throw throwable4;
                if (throwable != null) {
                    try {
                        ((InputStream)object).close();
                        throw throwable4;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    throw throwable4;
                } else {
                    ((InputStream)object).close();
                }
                throw throwable4;
            }
        }
        ((InputStream)object).close();
        return keyStore;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private KeyStore loadKeyStore(URL object, char[] object2) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore keyStore = KeyStore.getInstance(this.keyStoreType);
        object = ((URL)object).openStream();
        Throwable throwable = null;
        try {
            keyStore.load((InputStream)object, (char[])object2);
            if (object == null) return keyStore;
        }
        catch (Throwable throwable2) {
            try {
                Throwable throwable3 = throwable2;
                throwable = throwable2;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                if (object == null) throw throwable4;
                if (throwable != null) {
                    try {
                        ((InputStream)object).close();
                        throw throwable4;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    throw throwable4;
                } else {
                    ((InputStream)object).close();
                }
                throw throwable4;
            }
        }
        ((InputStream)object).close();
        return keyStore;
    }

    public SSLContext build() throws NoSuchAlgorithmException, KeyManagementException {
        Object object = this.protocol != null ? this.protocol : TLS;
        object = this.provider != null ? SSLContext.getInstance((String)object, this.provider) : SSLContext.getInstance((String)object);
        this.initSSLContext((SSLContext)object, this.keyManagers, this.trustManagers, this.secureRandom);
        return object;
    }

    private Provider requireNonNullProvider(String string) throws NoSuchProviderException {
        Provider provider = Security.getProvider(string);
        if (provider == null) {
            throw new NoSuchProviderException(string);
        }
        return provider;
    }

    public String toString() {
        return "[provider=" + this.provider + ", protocol=" + this.protocol + ", keyStoreType=" + this.keyStoreType + ", keyManagerFactoryAlgorithm=" + this.keyManagerFactoryAlgorithm + ", keyManagers=" + this.keyManagers + ", trustManagerFactoryAlgorithm=" + this.trustManagerFactoryAlgorithm + ", trustManagers=" + this.trustManagers + ", secureRandom=" + this.secureRandom + "]";
    }
}

