/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.util;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.util.TextUtils;
import org.apache.hc.core5.util.TimeValue;

public class Args {
    public static void check(boolean bl2, String string) {
        if (!bl2) {
            throw new IllegalArgumentException(string);
        }
    }

    public static void check(boolean bl2, String string, Object ... objectArray) {
        if (!bl2) {
            throw new IllegalArgumentException(String.format(string, objectArray));
        }
    }

    public static void check(boolean bl2, String string, Object object) {
        if (!bl2) {
            throw new IllegalArgumentException(String.format(string, object));
        }
    }

    @Deprecated
    public static long checkContentLength(EntityDetails entityDetails) {
        return Args.checkRange(entityDetails.getContentLength(), -1L, Integer.MAX_VALUE, "HTTP entity too large to be buffered in memory)");
    }

    public static int checkRange(int n2, int n3, int n4, String string) {
        if (n2 < n3 || n2 > n4) {
            throw Args.illegalArgumentException("%s: %d is out of range [%d, %d]", string, n2, n3, n4);
        }
        return n2;
    }

    public static long checkRange(long l2, long l3, long l4, String string) {
        if (l2 < l3 || l2 > l4) {
            throw Args.illegalArgumentException("%s: %d is out of range [%d, %d]", string, l2, l3, l4);
        }
        return l2;
    }

    public static <T extends CharSequence> T containsNoBlanks(T t2, String string) {
        Args.notNull(t2, string);
        if (Args.isEmpty(t2)) {
            throw Args.illegalArgumentExceptionNotEmpty(string);
        }
        if (TextUtils.containsBlanks(t2)) {
            throw new IllegalArgumentException(string + " must not contain blanks");
        }
        return t2;
    }

    private static IllegalArgumentException illegalArgumentException(String string, Object ... objectArray) {
        return new IllegalArgumentException(String.format(string, objectArray));
    }

    private static IllegalArgumentException illegalArgumentExceptionNotEmpty(String string) {
        return new IllegalArgumentException(string + " must not be empty");
    }

    public static <T extends CharSequence> T notBlank(T t2, String string) {
        Args.notNull(t2, string);
        if (TextUtils.isBlank(t2)) {
            throw new IllegalArgumentException(string + " must not be blank");
        }
        return t2;
    }

    public static <T extends CharSequence> T notEmpty(T t2, String string) {
        Args.notNull(t2, string);
        if (Args.isEmpty(t2)) {
            throw Args.illegalArgumentExceptionNotEmpty(string);
        }
        return t2;
    }

    public static <E, T extends Collection<E>> T notEmpty(T t2, String string) {
        Args.notNull(t2, string);
        if (Args.isEmpty(t2)) {
            throw Args.illegalArgumentExceptionNotEmpty(string);
        }
        return t2;
    }

    public static <T> T notEmpty(T t2, String string) {
        Args.notNull(t2, string);
        if (Args.isEmpty(t2)) {
            throw Args.illegalArgumentExceptionNotEmpty(string);
        }
        return t2;
    }

    public static int notNegative(int n2, String string) {
        if (n2 < 0) {
            throw Args.illegalArgumentException("%s must not be negative: %d", string, n2);
        }
        return n2;
    }

    public static long notNegative(long l2, String string) {
        if (l2 < 0L) {
            throw Args.illegalArgumentException("%s must not be negative: %d", string, l2);
        }
        return l2;
    }

    public static <T> T notNull(T t2, String string) {
        return Objects.requireNonNull(t2, string);
    }

    public static boolean isEmpty(Object object) {
        if (object == null) {
            return true;
        }
        if (object instanceof CharSequence) {
            return ((CharSequence)object).length() == 0;
        }
        if (object.getClass().isArray()) {
            return Array.getLength(object) == 0;
        }
        if (object instanceof Collection) {
            return ((Collection)object).isEmpty();
        }
        if (object instanceof Map) {
            return ((Map)object).isEmpty();
        }
        return false;
    }

    public static int positive(int n2, String string) {
        if (n2 <= 0) {
            throw Args.illegalArgumentException("%s must not be negative or zero: %d", string, n2);
        }
        return n2;
    }

    public static long positive(long l2, String string) {
        if (l2 <= 0L) {
            throw Args.illegalArgumentException("%s must not be negative or zero: %d", string, l2);
        }
        return l2;
    }

    public static <T extends TimeValue> T positive(T t2, String string) {
        Args.positive(t2.getDuration(), string);
        return t2;
    }

    private Args() {
    }
}

