/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.util;

import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.CharArrayBuffer;
import org.apache.hc.core5.util.TextUtils;

public final class ByteArrayBuffer
implements Serializable {
    private static final long serialVersionUID = 4359112959524048036L;
    private byte[] array;
    private int len;

    public ByteArrayBuffer(int n2) {
        Args.notNegative(n2, "Buffer capacity");
        this.array = new byte[n2];
    }

    private void expand(int n2) {
        byte[] byArray = new byte[Math.max(this.array.length << 1, n2)];
        System.arraycopy(this.array, 0, byArray, 0, this.len);
        this.array = byArray;
    }

    public final void append(byte[] byArray, int n2, int n3) {
        if (byArray == null) {
            return;
        }
        if (n2 < 0 || n2 > byArray.length || n3 < 0 || n2 + n3 < 0 || n2 + n3 > byArray.length) {
            throw new IndexOutOfBoundsException("off: " + n2 + " len: " + n3 + " b.length: " + byArray.length);
        }
        if (n3 == 0) {
            return;
        }
        int n4 = this.len + n3;
        if (n4 > this.array.length) {
            this.expand(n4);
        }
        System.arraycopy(byArray, n2, this.array, this.len, n3);
        this.len = n4;
    }

    public final void append(int n2) {
        int n3 = this.len + 1;
        if (n3 > this.array.length) {
            this.expand(n3);
        }
        this.array[this.len] = (byte)n2;
        this.len = n3;
    }

    public final void append(char[] cArray, int n2, int n3) {
        if (cArray == null) {
            return;
        }
        if (n2 < 0 || n2 > cArray.length || n3 < 0 || n2 + n3 < 0 || n2 + n3 > cArray.length) {
            throw new IndexOutOfBoundsException("off: " + n2 + " len: " + n3 + " b.length: " + cArray.length);
        }
        if (n3 == 0) {
            return;
        }
        int n4 = this.len;
        if ((n3 = n4 + n3) > this.array.length) {
            this.expand(n3);
        }
        while (n4 < n3) {
            this.array[n4] = TextUtils.castAsByte(cArray[n2]);
            ++n2;
            ++n4;
        }
        this.len = n3;
    }

    public final void append(CharArrayBuffer charArrayBuffer, int n2, int n3) {
        if (charArrayBuffer == null) {
            return;
        }
        this.append(charArrayBuffer.array(), n2, n3);
    }

    public final void append(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            return;
        }
        int n2 = byteBuffer.remaining();
        if (n2 > 0) {
            int n3 = this.len + n2;
            if (n3 > this.array.length) {
                this.expand(n3);
            }
            byteBuffer.get(this.array, this.len, n2);
            this.len = n3;
        }
    }

    public final void clear() {
        this.len = 0;
    }

    public final byte[] toByteArray() {
        byte[] byArray = new byte[this.len];
        if (this.len > 0) {
            System.arraycopy(this.array, 0, byArray, 0, this.len);
        }
        return byArray;
    }

    public final int byteAt(int n2) {
        return this.array[n2];
    }

    public final int capacity() {
        return this.array.length;
    }

    public final int length() {
        return this.len;
    }

    public final void ensureCapacity(int n2) {
        if (n2 <= 0) {
            return;
        }
        int n3 = this.array.length - this.len;
        if (n2 > n3) {
            ByteArrayBuffer byteArrayBuffer = this;
            byteArrayBuffer.expand(byteArrayBuffer.len + n2);
        }
    }

    public final byte[] array() {
        return this.array;
    }

    public final void setLength(int n2) {
        if (n2 < 0 || n2 > this.array.length) {
            throw new IndexOutOfBoundsException("len: " + n2 + " < 0 or > buffer len: " + this.array.length);
        }
        this.len = n2;
    }

    public final boolean isEmpty() {
        return this.len == 0;
    }

    public final boolean isFull() {
        return this.len == this.array.length;
    }

    public final int indexOf(byte by2, int n2, int n3) {
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 > this.len) {
            n3 = this.len;
        }
        if (n2 > n3) {
            return -1;
        }
        while (n2 < n3) {
            if (this.array[n2] == by2) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public final int indexOf(byte by2) {
        return this.indexOf(by2, 0, this.len);
    }
}

