/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.util;

import java.io.Serializable;
import java.nio.CharBuffer;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.ByteArrayBuffer;

public final class CharArrayBuffer
implements Serializable,
CharSequence {
    private static final long serialVersionUID = -6208952725094867135L;
    private char[] array;
    private int len;

    public CharArrayBuffer(int n2) {
        Args.notNegative(n2, "Buffer capacity");
        this.array = new char[n2];
    }

    private void expand(int n2) {
        char[] cArray = new char[Math.max(this.array.length << 1, n2)];
        System.arraycopy(this.array, 0, cArray, 0, this.len);
        this.array = cArray;
    }

    public final void append(char[] cArray, int n2, int n3) {
        if (cArray == null) {
            return;
        }
        if (n2 < 0 || n2 > cArray.length || n3 < 0 || n2 + n3 < 0 || n2 + n3 > cArray.length) {
            throw new IndexOutOfBoundsException("off: " + n2 + " len: " + n3 + " b.length: " + cArray.length);
        }
        if (n3 == 0) {
            return;
        }
        int n4 = this.len + n3;
        if (n4 > this.array.length) {
            this.expand(n4);
        }
        System.arraycopy(cArray, n2, this.array, this.len, n3);
        this.len = n4;
    }

    public final void append(String string) {
        int n2 = (string = string != null ? string : "null").length();
        int n3 = this.len + n2;
        if (n3 > this.array.length) {
            this.expand(n3);
        }
        string.getChars(0, n2, this.array, this.len);
        this.len = n3;
    }

    public final void append(CharArrayBuffer charArrayBuffer, int n2, int n3) {
        if (charArrayBuffer == null) {
            return;
        }
        this.append(charArrayBuffer.array, n2, n3);
    }

    public final void append(CharArrayBuffer charArrayBuffer) {
        if (charArrayBuffer == null) {
            return;
        }
        this.append(charArrayBuffer.array, 0, charArrayBuffer.len);
    }

    public final void append(char c2) {
        int n2 = this.len + 1;
        if (n2 > this.array.length) {
            this.expand(n2);
        }
        this.array[this.len] = c2;
        this.len = n2;
    }

    public final void append(byte[] byArray, int n2, int n3) {
        if (byArray == null) {
            return;
        }
        if (n2 < 0 || n2 > byArray.length || n3 < 0 || n2 + n3 < 0 || n2 + n3 > byArray.length) {
            throw new IndexOutOfBoundsException("off: " + n2 + " len: " + n3 + " b.length: " + byArray.length);
        }
        if (n3 == 0) {
            return;
        }
        int n4 = this.len;
        if ((n3 = n4 + n3) > this.array.length) {
            this.expand(n3);
        }
        while (n4 < n3) {
            this.array[n4] = (char)(byArray[n2] & 0xFF);
            ++n2;
            ++n4;
        }
        this.len = n3;
    }

    public final void append(ByteArrayBuffer byteArrayBuffer, int n2, int n3) {
        if (byteArrayBuffer == null) {
            return;
        }
        this.append(byteArrayBuffer.array(), n2, n3);
    }

    public final void append(Object object) {
        this.append(String.valueOf(object));
    }

    public final void clear() {
        this.len = 0;
    }

    public final char[] toCharArray() {
        char[] cArray = new char[this.len];
        if (this.len > 0) {
            System.arraycopy(this.array, 0, cArray, 0, this.len);
        }
        return cArray;
    }

    @Override
    public final char charAt(int n2) {
        return this.array[n2];
    }

    public final char[] array() {
        return this.array;
    }

    public final int capacity() {
        return this.array.length;
    }

    @Override
    public final int length() {
        return this.len;
    }

    public final void ensureCapacity(int n2) {
        if (n2 <= 0) {
            return;
        }
        int n3 = this.array.length - this.len;
        if (n2 > n3) {
            CharArrayBuffer charArrayBuffer = this;
            charArrayBuffer.expand(charArrayBuffer.len + n2);
        }
    }

    public final void setLength(int n2) {
        if (n2 < 0 || n2 > this.array.length) {
            throw new IndexOutOfBoundsException("len: " + n2 + " < 0 or > buffer len: " + this.array.length);
        }
        this.len = n2;
    }

    @Override
    public final boolean isEmpty() {
        return this.len == 0;
    }

    public final boolean isFull() {
        return this.len == this.array.length;
    }

    public final int indexOf(int n2, int n3, int n4) {
        if (n3 < 0) {
            n3 = 0;
        }
        if (n4 > this.len) {
            n4 = this.len;
        }
        if (n3 > n4) {
            return -1;
        }
        while (n3 < n4) {
            if (this.array[n3] == n2) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    public final int indexOf(int n2) {
        return this.indexOf(n2, 0, this.len);
    }

    public final String substring(int n2, int n3) {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("Negative beginIndex: " + n2);
        }
        if (n3 > this.len) {
            throw new IndexOutOfBoundsException("endIndex: " + n3 + " > length: " + this.len);
        }
        if (n2 > n3) {
            throw new IndexOutOfBoundsException("beginIndex: " + n2 + " > endIndex: " + n3);
        }
        return new String(this.array, n2, n3 - n2);
    }

    private static boolean isWhitespace(char c2) {
        return c2 == ' ' || c2 == '\t' || c2 == '\r' || c2 == '\n';
    }

    public final String substringTrimmed(int n2, int n3) {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("Negative beginIndex: " + n2);
        }
        if (n3 > this.len) {
            throw new IndexOutOfBoundsException("endIndex: " + n3 + " > length: " + this.len);
        }
        if (n2 > n3) {
            throw new IndexOutOfBoundsException("beginIndex: " + n2 + " > endIndex: " + n3);
        }
        int n4 = n3;
        while (n2 < n3 && CharArrayBuffer.isWhitespace(this.array[n2])) {
            ++n2;
        }
        while (n4 > n2 && CharArrayBuffer.isWhitespace(this.array[n4 - 1])) {
            --n4;
        }
        return new String(this.array, n2, n4 - n2);
    }

    @Override
    public final CharSequence subSequence(int n2, int n3) {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("Negative beginIndex: " + n2);
        }
        if (n3 > this.len) {
            throw new IndexOutOfBoundsException("endIndex: " + n3 + " > length: " + this.len);
        }
        if (n2 > n3) {
            throw new IndexOutOfBoundsException("beginIndex: " + n2 + " > endIndex: " + n3);
        }
        return CharBuffer.wrap(this.array, n2, n3 - n2);
    }

    @Override
    public final String toString() {
        return new String(this.array, 0, this.len);
    }
}

