/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.util;

import java.text.ParseException;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.TimeValue;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class Timeout
extends TimeValue {
    public static final Timeout ZERO_MILLISECONDS = Timeout.of(0L, TimeUnit.MILLISECONDS);
    public static final Timeout ONE_MILLISECOND = Timeout.of(1L, TimeUnit.MILLISECONDS);
    public static final Timeout DISABLED = ZERO_MILLISECONDS;
    public static final Timeout INFINITE = ZERO_MILLISECONDS;

    public static Timeout defaultsToDisabled(Timeout timeout) {
        return Timeout.defaultsTo(timeout, DISABLED);
    }

    public static Timeout defaultsToInfinite(Timeout timeout) {
        return Timeout.defaultsTo(timeout, DISABLED);
    }

    public static Timeout of(Duration duration) {
        long l2 = duration.getSeconds();
        long l3 = duration.getNano();
        if (l2 == 0L) {
            return Timeout.of(l3, TimeUnit.NANOSECONDS);
        }
        if (l3 == 0L) {
            return Timeout.of(l2, TimeUnit.SECONDS);
        }
        try {
            return Timeout.of(duration.toNanos(), TimeUnit.NANOSECONDS);
        }
        catch (ArithmeticException arithmeticException) {
            try {
                return Timeout.of(duration.toMillis(), TimeUnit.MILLISECONDS);
            }
            catch (ArithmeticException arithmeticException2) {
                return Timeout.of(l2, TimeUnit.SECONDS);
            }
        }
    }

    public static Timeout of(long l2, TimeUnit timeUnit) {
        return new Timeout(l2, timeUnit);
    }

    public static Timeout ofDays(long l2) {
        return Timeout.of(l2, TimeUnit.DAYS);
    }

    public static Timeout ofHours(long l2) {
        return Timeout.of(l2, TimeUnit.HOURS);
    }

    public static Timeout ofMicroseconds(long l2) {
        return Timeout.of(l2, TimeUnit.MICROSECONDS);
    }

    public static Timeout ofMilliseconds(long l2) {
        return Timeout.of(l2, TimeUnit.MILLISECONDS);
    }

    public static Timeout ofMinutes(long l2) {
        return Timeout.of(l2, TimeUnit.MINUTES);
    }

    public static Timeout ofNanoseconds(long l2) {
        return Timeout.of(l2, TimeUnit.NANOSECONDS);
    }

    public static Timeout ofSeconds(long l2) {
        return Timeout.of(l2, TimeUnit.SECONDS);
    }

    public static Timeout parse(String string) throws ParseException {
        return TimeValue.parse(string).toTimeout();
    }

    Timeout(long l2, TimeUnit timeUnit) {
        super(Args.notNegative(l2, "duration"), Args.notNull(timeUnit, "timeUnit"));
    }

    public boolean isDisabled() {
        return this.getDuration() == 0L;
    }

    public boolean isEnabled() {
        return !this.isDisabled();
    }
}

