/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.util;

import org.apache.hc.core5.util.Args;

public class Tokenizer$Cursor {
    private final int lowerBound;
    private final int upperBound;
    private int pos;

    public Tokenizer$Cursor(int n2, int n3) {
        Args.notNegative(n2, "lowerBound");
        Args.check(n2 <= n3, "lowerBound cannot be greater than upperBound");
        this.lowerBound = n2;
        this.upperBound = n3;
        this.pos = n2;
    }

    public int getLowerBound() {
        return this.lowerBound;
    }

    public int getUpperBound() {
        return this.upperBound;
    }

    public int getPos() {
        return this.pos;
    }

    public void updatePos(int n2) {
        Args.check(n2 >= this.lowerBound, "pos: %s < lowerBound: %s", n2, this.lowerBound);
        Args.check(n2 <= this.upperBound, "pos: %s > upperBound: %s", n2, this.upperBound);
        this.pos = n2;
    }

    public boolean atEnd() {
        return this.pos >= this.upperBound;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        stringBuilder.append(this.lowerBound);
        stringBuilder.append('>');
        stringBuilder.append(this.pos);
        stringBuilder.append('>');
        stringBuilder.append(this.upperBound);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

