/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.apache.hc.core5.util.Args;

public class VersionInfo {
    public static final String UNAVAILABLE = "UNAVAILABLE";
    public static final String VERSION_PROPERTY_FILE = "version.properties";
    public static final String PROPERTY_MODULE = "info.module";
    public static final String PROPERTY_RELEASE = "info.release";
    @Deprecated
    public static final String PROPERTY_TIMESTAMP = "info.timestamp";
    private final String infoPackage;
    private final String infoModule;
    private final String infoRelease;
    private final String infoTimestamp;
    private final String infoClassloader;
    private static final VersionInfo[] EMPTY_VERSION_INFO_ARRAY = new VersionInfo[0];

    protected VersionInfo(String string, String string2, String string3, String string4, String string5) {
        Args.notNull(string, "Package identifier");
        this.infoPackage = string;
        this.infoModule = string2 != null ? string2 : UNAVAILABLE;
        this.infoRelease = string3 != null ? string3 : UNAVAILABLE;
        this.infoTimestamp = string4 != null ? string4 : UNAVAILABLE;
        this.infoClassloader = string5 != null ? string5 : UNAVAILABLE;
    }

    public final String getPackage() {
        return this.infoPackage;
    }

    public final String getModule() {
        return this.infoModule;
    }

    public final String getRelease() {
        return this.infoRelease;
    }

    @Deprecated
    public final String getTimestamp() {
        return this.infoTimestamp;
    }

    public final String getClassloader() {
        return this.infoClassloader;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(20 + this.infoPackage.length() + this.infoModule.length() + this.infoRelease.length() + this.infoTimestamp.length() + this.infoClassloader.length());
        stringBuilder.append("VersionInfo(").append(this.infoPackage).append(':').append(this.infoModule);
        if (!UNAVAILABLE.equals(this.infoRelease)) {
            stringBuilder.append(':').append(this.infoRelease);
        }
        stringBuilder.append(')');
        if (!UNAVAILABLE.equals(this.infoClassloader)) {
            stringBuilder.append('@').append(this.infoClassloader);
        }
        return stringBuilder.toString();
    }

    public static VersionInfo[] loadVersionInfo(String[] stringArray, ClassLoader classLoader) {
        Args.notNull(stringArray, "Package identifier array");
        ArrayList<VersionInfo> arrayList = new ArrayList<VersionInfo>(stringArray.length);
        for (String string : stringArray) {
            VersionInfo object = VersionInfo.loadVersionInfo(string, classLoader);
            if (object == null) continue;
            arrayList.add(object);
        }
        return arrayList.toArray(EMPTY_VERSION_INFO_ARRAY);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static VersionInfo loadVersionInfo(String string, ClassLoader classLoader) {
        Object object;
        Properties properties;
        block10: {
            Args.notNull(string, "Package identifier");
            classLoader = classLoader != null ? classLoader : Thread.currentThread().getContextClassLoader();
            properties = null;
            try {
                object = classLoader.getResourceAsStream(string.replace('.', '/') + "/version.properties");
                Throwable throwable = null;
                try {
                    if (object != null) {
                        Properties properties2 = new Properties();
                        properties2.load((InputStream)object);
                        properties = properties2;
                    }
                    if (object == null) break block10;
                }
                catch (Throwable throwable2) {
                    try {
                        Throwable throwable3 = throwable2;
                        throwable = throwable2;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (object == null) throw throwable4;
                        if (throwable == null) {
                            ((InputStream)object).close();
                            throw throwable4;
                        }
                        try {
                            ((InputStream)object).close();
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                            throw throwable4;
                        }
                    }
                }
                ((InputStream)object).close();
            }
            catch (IOException iOException) {}
        }
        object = null;
        if (properties == null) return object;
        return VersionInfo.fromMap(string, properties, classLoader);
    }

    protected static VersionInfo fromMap(String string, Map<?, ?> object, ClassLoader classLoader) {
        Args.notNull(string, "Package identifier");
        String string2 = null;
        String string3 = null;
        if (object != null) {
            string2 = (String)object.get(PROPERTY_MODULE);
            if (string2 != null && string2.length() <= 0) {
                string2 = null;
            }
            if ((string3 = (String)object.get(PROPERTY_RELEASE)) != null && (string3.length() <= 0 || string3.equals("${project.version}"))) {
                string3 = null;
            }
        }
        object = null;
        if (classLoader != null) {
            object = classLoader.toString();
        }
        return new VersionInfo(string, string2, string3, null, (String)object);
    }

    public static String getSoftwareInfo(String string, String object, Class<?> object2) {
        object = (object = VersionInfo.loadVersionInfo((String)object, ((Class)object2).getClassLoader())) != null ? ((VersionInfo)object).getRelease() : UNAVAILABLE;
        object2 = System.getProperty("java.version");
        if (!UNAVAILABLE.equals(object)) {
            string = string + "/" + (String)object;
        }
        return String.format("%s (Java/%s)", string, object2);
    }
}

