/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import java.util.Locale;
import org.json.HTTPTokener;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class HTTP {
    public static final String CRLF = "\r\n";

    public static JSONObject toJSONObject(String object) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        String string = ((HTTPTokener)(object = new HTTPTokener((String)object))).nextToken();
        if (string.toUpperCase(Locale.ROOT).startsWith("HTTP")) {
            jSONObject.put("HTTP-Version", string);
            jSONObject.put("Status-Code", ((HTTPTokener)object).nextToken());
            jSONObject.put("Reason-Phrase", ((JSONTokener)object).nextTo('\u0000'));
            ((JSONTokener)object).next();
        } else {
            jSONObject.put("Method", string);
            jSONObject.put("Request-URI", ((HTTPTokener)object).nextToken());
            jSONObject.put("HTTP-Version", ((HTTPTokener)object).nextToken());
        }
        while (((JSONTokener)object).more()) {
            string = ((JSONTokener)object).nextTo(':');
            ((JSONTokener)object).next(':');
            jSONObject.put(string, ((JSONTokener)object).nextTo('\u0000'));
            ((JSONTokener)object).next();
        }
        return jSONObject;
    }

    public static String toString(JSONObject jSONObject) throws JSONException {
        StringBuilder stringBuilder = new StringBuilder();
        if (jSONObject.has("Status-Code") && jSONObject.has("Reason-Phrase")) {
            stringBuilder.append(jSONObject.getString("HTTP-Version"));
            stringBuilder.append(' ');
            stringBuilder.append(jSONObject.getString("Status-Code"));
            stringBuilder.append(' ');
            stringBuilder.append(jSONObject.getString("Reason-Phrase"));
        } else if (jSONObject.has("Method") && jSONObject.has("Request-URI")) {
            stringBuilder.append(jSONObject.getString("Method"));
            stringBuilder.append(' ');
            stringBuilder.append('\"');
            stringBuilder.append(jSONObject.getString("Request-URI"));
            stringBuilder.append('\"');
            stringBuilder.append(' ');
            stringBuilder.append(jSONObject.getString("HTTP-Version"));
        } else {
            throw new JSONException("Not enough material for an HTTP header.");
        }
        stringBuilder.append(CRLF);
        for (String string : jSONObject.keySet()) {
            String string2 = jSONObject.optString(string);
            if ("HTTP-Version".equals(string) || "Status-Code".equals(string) || "Reason-Phrase".equals(string) || "Method".equals(string) || "Request-URI".equals(string) || JSONObject.NULL.equals(string2)) continue;
            stringBuilder.append(string);
            stringBuilder.append(": ");
            stringBuilder.append(jSONObject.optString(string));
            stringBuilder.append(CRLF);
        }
        stringBuilder.append(CRLF);
        return stringBuilder.toString();
    }
}

