/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONParserConfiguration;

public class JSONTokener {
    private long character;
    private boolean eof;
    private long index;
    private long line;
    private char previous;
    private final Reader reader;
    private boolean usePrevious;
    private long characterPreviousLine;
    private JSONParserConfiguration jsonParserConfiguration;

    public JSONTokener(Reader reader) {
        this(reader, new JSONParserConfiguration());
    }

    public JSONTokener(Reader reader, JSONParserConfiguration jSONParserConfiguration) {
        this.jsonParserConfiguration = jSONParserConfiguration;
        this.reader = reader.markSupported() ? reader : new BufferedReader(reader);
        this.eof = false;
        this.usePrevious = false;
        this.previous = '\u0000';
        this.index = 0L;
        this.character = 1L;
        this.characterPreviousLine = 0L;
        this.line = 1L;
    }

    public JSONTokener(InputStream inputStream) {
        this(inputStream, new JSONParserConfiguration());
    }

    public JSONTokener(InputStream inputStream, JSONParserConfiguration jSONParserConfiguration) {
        this(new InputStreamReader(inputStream, Charset.forName("UTF-8")), jSONParserConfiguration);
    }

    public JSONTokener(String string) {
        this(new StringReader(string));
    }

    public JSONTokener(String string, JSONParserConfiguration jSONParserConfiguration) {
        this(new StringReader(string), jSONParserConfiguration);
    }

    public JSONParserConfiguration getJsonParserConfiguration() {
        return this.jsonParserConfiguration;
    }

    @Deprecated
    public void setJsonParserConfiguration(JSONParserConfiguration jSONParserConfiguration) {
        this.jsonParserConfiguration = jSONParserConfiguration;
    }

    public void back() throws JSONException {
        if (this.usePrevious || this.index <= 0L) {
            throw new JSONException("Stepping back two steps is not supported");
        }
        this.decrementIndexes();
        this.usePrevious = true;
        this.eof = false;
    }

    private void decrementIndexes() {
        --this.index;
        if (this.previous == '\r' || this.previous == '\n') {
            --this.line;
            this.character = this.characterPreviousLine;
            return;
        }
        if (this.character > 0L) {
            --this.character;
        }
    }

    public static int dehexchar(char c2) {
        if (c2 >= '0' && c2 <= '9') {
            return c2 - 48;
        }
        if (c2 >= 'A' && c2 <= 'F') {
            return c2 - 55;
        }
        if (c2 >= 'a' && c2 <= 'f') {
            return c2 - 87;
        }
        return -1;
    }

    public boolean end() {
        return this.eof && !this.usePrevious;
    }

    public boolean more() throws JSONException {
        if (this.usePrevious) {
            return true;
        }
        try {
            this.reader.mark(1);
        }
        catch (IOException iOException) {
            throw new JSONException("Unable to preserve stream position", iOException);
        }
        try {
            if (this.reader.read() <= 0) {
                this.eof = true;
                return false;
            }
            this.reader.reset();
        }
        catch (IOException iOException) {
            throw new JSONException("Unable to read the next character from the stream", iOException);
        }
        return true;
    }

    public char next() throws JSONException {
        int n2;
        if (this.usePrevious) {
            this.usePrevious = false;
            n2 = this.previous;
        } else {
            try {
                n2 = this.reader.read();
            }
            catch (IOException iOException) {
                throw new JSONException(iOException);
            }
        }
        if (n2 <= 0) {
            this.eof = true;
            return '\u0000';
        }
        this.incrementIndexes(n2);
        this.previous = (char)n2;
        return this.previous;
    }

    protected char getPrevious() {
        return this.previous;
    }

    private void incrementIndexes(int n2) {
        if (n2 > 0) {
            ++this.index;
            if (n2 == 13) {
                ++this.line;
                this.characterPreviousLine = this.character;
                this.character = 0L;
                return;
            }
            if (n2 == 10) {
                if (this.previous != '\r') {
                    ++this.line;
                    this.characterPreviousLine = this.character;
                }
                this.character = 0L;
                return;
            }
            ++this.character;
        }
    }

    public char next(char c2) throws JSONException {
        char c3 = this.next();
        if (c3 != c2) {
            if (c3 > '\u0000') {
                throw this.syntaxError("Expected '" + c2 + "' and instead saw '" + c3 + "'");
            }
            throw this.syntaxError("Expected '" + c2 + "' and instead saw ''");
        }
        return c3;
    }

    public String next(int n2) throws JSONException {
        if (n2 == 0) {
            return "";
        }
        char[] cArray = new char[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            cArray[i2] = this.next();
            if (!this.end()) continue;
            throw this.syntaxError("Substring bounds error");
        }
        return new String(cArray);
    }

    public char nextClean() throws JSONException {
        char c2;
        while ((c2 = this.next()) != '\u0000' && c2 <= ' ') {
        }
        return c2;
    }

    public String nextString(char c2) throws JSONException {
        StringBuilder stringBuilder = new StringBuilder();
        block15: while (true) {
            char c3 = this.next();
            switch (c3) {
                case '\u0000': 
                case '\n': 
                case '\r': {
                    throw this.syntaxError("Unterminated string. Character with int code " + c3 + " is not allowed within a quoted string.");
                }
                case '\\': {
                    c3 = this.next();
                    switch (c3) {
                        case 'b': {
                            stringBuilder.append('\b');
                            continue block15;
                        }
                        case 't': {
                            stringBuilder.append('\t');
                            continue block15;
                        }
                        case 'n': {
                            stringBuilder.append('\n');
                            continue block15;
                        }
                        case 'f': {
                            stringBuilder.append('\f');
                            continue block15;
                        }
                        case 'r': {
                            stringBuilder.append('\r');
                            continue block15;
                        }
                        case 'u': {
                            String string = this.next(4);
                            try {
                                stringBuilder.append((char)Integer.parseInt(string, 16));
                                continue block15;
                            }
                            catch (NumberFormatException numberFormatException) {
                                throw this.syntaxError("Illegal escape. \\u must be followed by a 4 digit hexadecimal number. \\" + string + " is not valid.", numberFormatException);
                            }
                        }
                        case '\"': 
                        case '\'': 
                        case '/': 
                        case '\\': {
                            stringBuilder.append(c3);
                            continue block15;
                        }
                    }
                    throw this.syntaxError("Illegal escape. Escape sequence  \\" + c3 + " is not valid.");
                }
            }
            if (c3 == c2) {
                return stringBuilder.toString();
            }
            stringBuilder.append(c3);
        }
    }

    public String nextTo(char c2) throws JSONException {
        StringBuilder stringBuilder = new StringBuilder();
        while (true) {
            char c3;
            if ((c3 = this.next()) == c2 || c3 == '\u0000' || c3 == '\n' || c3 == '\r') {
                if (c3 != '\u0000') {
                    this.back();
                }
                return stringBuilder.toString().trim();
            }
            stringBuilder.append(c3);
        }
    }

    public String nextTo(String string) throws JSONException {
        StringBuilder stringBuilder = new StringBuilder();
        while (true) {
            char c2;
            if (string.indexOf(c2 = this.next()) >= 0 || c2 == '\u0000' || c2 == '\n' || c2 == '\r') {
                if (c2 != '\u0000') {
                    this.back();
                }
                return stringBuilder.toString().trim();
            }
            stringBuilder.append(c2);
        }
    }

    public Object nextValue() throws JSONException {
        char c2 = this.nextClean();
        switch (c2) {
            case '{': {
                this.back();
                try {
                    JSONTokener jSONTokener = this;
                    return new JSONObject(jSONTokener, jSONTokener.jsonParserConfiguration);
                }
                catch (StackOverflowError stackOverflowError) {
                    throw new JSONException("JSON Array or Object depth too large to process.", stackOverflowError);
                }
            }
            case '[': {
                this.back();
                try {
                    JSONTokener jSONTokener = this;
                    return new JSONArray(jSONTokener, jSONTokener.jsonParserConfiguration);
                }
                catch (StackOverflowError stackOverflowError) {
                    throw new JSONException("JSON Array or Object depth too large to process.", stackOverflowError);
                }
            }
        }
        return this.nextSimpleValue(c2);
    }

    Object nextSimpleValue(char c2) {
        Object object;
        if (this.jsonParserConfiguration != null && this.jsonParserConfiguration.isStrictMode() && c2 == '\'') {
            throw this.syntaxError("Strict mode error: Single quoted strings are not allowed");
        }
        switch (c2) {
            case '\"': 
            case '\'': {
                return this.nextString(c2);
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        while (c2 >= ' ' && ",:]}/\\\"[{;=#".indexOf(c2) < 0) {
            stringBuilder.append(c2);
            c2 = this.next();
        }
        if (!this.eof) {
            this.back();
        }
        if ("".equals(object = stringBuilder.toString().trim())) {
            throw this.syntaxError("Missing value");
        }
        object = JSONObject.stringToValue((String)object);
        if (this.jsonParserConfiguration != null && this.jsonParserConfiguration.isStrictMode() && object instanceof String) {
            throw this.syntaxError(String.format("Strict mode error: Value '%s' is not surrounded by quotes", object));
        }
        return object;
    }

    public char skipTo(char c2) throws JSONException {
        char c3;
        try {
            long l2 = this.index;
            long l3 = this.character;
            long l4 = this.line;
            this.reader.mark(1000000);
            do {
                if ((c3 = this.next()) != '\u0000') continue;
                this.reader.reset();
                this.index = l2;
                this.character = l3;
                this.line = l4;
                return '\u0000';
            } while (c3 != c2);
            this.reader.mark(1);
        }
        catch (IOException iOException) {
            throw new JSONException(iOException);
        }
        this.back();
        return c3;
    }

    public JSONException syntaxError(String string) {
        return new JSONException(string + this.toString());
    }

    public JSONException syntaxError(String string, Throwable throwable) {
        return new JSONException(string + this.toString(), throwable);
    }

    public String toString() {
        return " at " + this.index + " [character " + this.character + " line " + this.line + "]";
    }

    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
    }
}

