/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.json.ParserConfiguration;
import org.json.XMLXsiTypeConverter;

public class XMLParserConfiguration
extends ParserConfiguration {
    private boolean keepNumberAsString;
    private boolean keepBooleanAsString;
    public static final XMLParserConfiguration ORIGINAL = new XMLParserConfiguration();
    public static final XMLParserConfiguration KEEP_STRINGS = new XMLParserConfiguration().withKeepStrings(true);
    private String cDataTagName;
    private boolean convertNilAttributeToNull;
    private boolean closeEmptyTag;
    private Map<String, XMLXsiTypeConverter<?>> xsiTypeMap;
    private Set<String> forceList;
    private boolean shouldTrimWhiteSpace;

    public XMLParserConfiguration() {
        this.cDataTagName = "content";
        this.convertNilAttributeToNull = false;
        this.xsiTypeMap = Collections.emptyMap();
        this.forceList = Collections.emptySet();
        this.shouldTrimWhiteSpace = true;
    }

    @Deprecated
    public XMLParserConfiguration(boolean bl2) {
        this(bl2, "content", false);
    }

    @Deprecated
    public XMLParserConfiguration(String string) {
        this(false, string, false);
    }

    @Deprecated
    public XMLParserConfiguration(boolean bl2, String string) {
        super(bl2, 512);
        this.cDataTagName = string;
        this.convertNilAttributeToNull = false;
    }

    @Deprecated
    public XMLParserConfiguration(boolean bl2, String string, boolean bl3) {
        super(false, 512);
        this.keepNumberAsString = bl2;
        this.keepBooleanAsString = bl2;
        this.cDataTagName = string;
        this.convertNilAttributeToNull = bl3;
    }

    private XMLParserConfiguration(boolean bl2, String string, boolean bl3, Map<String, XMLXsiTypeConverter<?>> map, Set<String> set, int n2, boolean bl4, boolean bl5, boolean bl6) {
        super(false, n2);
        this.keepNumberAsString = bl5;
        this.keepBooleanAsString = bl6;
        this.cDataTagName = string;
        this.convertNilAttributeToNull = bl3;
        this.xsiTypeMap = Collections.unmodifiableMap(map);
        this.forceList = Collections.unmodifiableSet(set);
        this.closeEmptyTag = bl4;
    }

    @Override
    protected XMLParserConfiguration clone() {
        XMLParserConfiguration xMLParserConfiguration = new XMLParserConfiguration(this.keepStrings, this.cDataTagName, this.convertNilAttributeToNull, this.xsiTypeMap, this.forceList, this.maxNestingDepth, this.closeEmptyTag, this.keepNumberAsString, this.keepBooleanAsString);
        new XMLParserConfiguration(this.keepStrings, this.cDataTagName, this.convertNilAttributeToNull, this.xsiTypeMap, this.forceList, this.maxNestingDepth, this.closeEmptyTag, this.keepNumberAsString, this.keepBooleanAsString).shouldTrimWhiteSpace = this.shouldTrimWhiteSpace;
        return xMLParserConfiguration;
    }

    public XMLParserConfiguration withKeepStrings(boolean bl2) {
        XMLParserConfiguration xMLParserConfiguration = this.clone();
        this.clone().keepStrings = bl2;
        xMLParserConfiguration.keepNumberAsString = bl2;
        xMLParserConfiguration.keepBooleanAsString = bl2;
        return xMLParserConfiguration;
    }

    public XMLParserConfiguration withKeepNumberAsString(boolean bl2) {
        XMLParserConfiguration xMLParserConfiguration = this.clone();
        this.clone().keepNumberAsString = bl2;
        xMLParserConfiguration.keepStrings = xMLParserConfiguration.keepBooleanAsString && xMLParserConfiguration.keepNumberAsString;
        return xMLParserConfiguration;
    }

    public XMLParserConfiguration withKeepBooleanAsString(boolean bl2) {
        XMLParserConfiguration xMLParserConfiguration = this.clone();
        this.clone().keepBooleanAsString = bl2;
        xMLParserConfiguration.keepStrings = xMLParserConfiguration.keepBooleanAsString && xMLParserConfiguration.keepNumberAsString;
        return xMLParserConfiguration;
    }

    public String getcDataTagName() {
        return this.cDataTagName;
    }

    public boolean isKeepNumberAsString() {
        return this.keepNumberAsString;
    }

    public boolean isKeepBooleanAsString() {
        return this.keepBooleanAsString;
    }

    public XMLParserConfiguration withcDataTagName(String string) {
        XMLParserConfiguration xMLParserConfiguration = this.clone();
        this.clone().cDataTagName = string;
        return xMLParserConfiguration;
    }

    public boolean isConvertNilAttributeToNull() {
        return this.convertNilAttributeToNull;
    }

    public XMLParserConfiguration withConvertNilAttributeToNull(boolean bl2) {
        XMLParserConfiguration xMLParserConfiguration = this.clone();
        this.clone().convertNilAttributeToNull = bl2;
        return xMLParserConfiguration;
    }

    public Map<String, XMLXsiTypeConverter<?>> getXsiTypeMap() {
        return this.xsiTypeMap;
    }

    public XMLParserConfiguration withXsiTypeMap(Map<String, XMLXsiTypeConverter<?>> map) {
        XMLParserConfiguration xMLParserConfiguration = this.clone();
        map = new HashMap(map);
        xMLParserConfiguration.xsiTypeMap = Collections.unmodifiableMap(map);
        return xMLParserConfiguration;
    }

    public Set<String> getForceList() {
        return this.forceList;
    }

    public XMLParserConfiguration withForceList(Set<String> set) {
        XMLParserConfiguration xMLParserConfiguration = this.clone();
        set = new HashSet<String>(set);
        xMLParserConfiguration.forceList = Collections.unmodifiableSet(set);
        return xMLParserConfiguration;
    }

    public XMLParserConfiguration withMaxNestingDepth(int n2) {
        return (XMLParserConfiguration)super.withMaxNestingDepth(n2);
    }

    public XMLParserConfiguration withCloseEmptyTag(boolean bl2) {
        XMLParserConfiguration xMLParserConfiguration = this.clone();
        this.clone().closeEmptyTag = bl2;
        return xMLParserConfiguration;
    }

    public XMLParserConfiguration withShouldTrimWhitespace(boolean bl2) {
        XMLParserConfiguration xMLParserConfiguration = this.clone();
        this.clone().shouldTrimWhiteSpace = bl2;
        return xMLParserConfiguration;
    }

    public boolean isCloseEmptyTag() {
        return this.closeEmptyTag;
    }

    public boolean shouldTrimWhiteSpace() {
        return this.shouldTrimWhiteSpace;
    }
}

