/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import java.io.Reader;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONTokener;
import org.json.XML;
import org.json.XMLParserConfiguration;

public class XMLTokener
extends JSONTokener {
    public static final HashMap<String, Character> entity = new HashMap<String, Character>(8);
    private XMLParserConfiguration configuration = XMLParserConfiguration.ORIGINAL;

    public XMLTokener(Reader reader) {
        super(reader);
    }

    public XMLTokener(String string) {
        super(string);
    }

    public XMLTokener(Reader reader, XMLParserConfiguration xMLParserConfiguration) {
        super(reader);
        this.configuration = xMLParserConfiguration;
    }

    public String nextCDATA() throws JSONException {
        StringBuilder stringBuilder = new StringBuilder();
        while (this.more()) {
            int n2 = this.next();
            stringBuilder.append((char)n2);
            n2 = stringBuilder.length() - 3;
            if (n2 < 0 || stringBuilder.charAt(n2) != ']' || stringBuilder.charAt(n2 + 1) != ']' || stringBuilder.charAt(n2 + 2) != '>') continue;
            stringBuilder.setLength(n2);
            return stringBuilder.toString();
        }
        throw this.syntaxError("Unclosed CDATA");
    }

    public Object nextContent() throws JSONException {
        char c2;
        while (Character.isWhitespace(c2 = this.next()) && this.configuration.shouldTrimWhiteSpace()) {
        }
        if (c2 == '\u0000') {
            return null;
        }
        if (c2 == '<') {
            return XML.LT;
        }
        StringBuilder stringBuilder = new StringBuilder();
        while (c2 != '\u0000') {
            if (c2 == '<') {
                this.back();
                if (this.configuration.shouldTrimWhiteSpace()) {
                    return stringBuilder.toString().trim();
                }
                return stringBuilder.toString();
            }
            if (c2 == '&') {
                stringBuilder.append(this.nextEntity(c2));
            } else {
                stringBuilder.append(c2);
            }
            c2 = this.next();
        }
        return stringBuilder.toString().trim();
    }

    public Object nextEntity(char c2) throws JSONException {
        char c3;
        StringBuilder stringBuilder = new StringBuilder();
        while (Character.isLetterOrDigit(c3 = this.next()) || c3 == '#') {
            stringBuilder.append(Character.toLowerCase(c3));
        }
        if (c3 != ';') {
            throw this.syntaxError("Missing ';' in XML entity: &" + stringBuilder);
        }
        String string = stringBuilder.toString();
        return XMLTokener.unescapeEntity(string);
    }

    static String unescapeEntity(String string) {
        if (string == null || string.isEmpty()) {
            return "";
        }
        if (string.charAt(0) == '#') {
            int n2 = string.charAt(1) == 'x' || string.charAt(1) == 'X' ? Integer.parseInt(string.substring(2), 16) : Integer.parseInt(string.substring(1));
            return new String(new int[]{n2}, 0, 1);
        }
        Character c2 = entity.get(string);
        if (c2 == null) {
            return "&" + string + ';';
        }
        return c2.toString();
    }

    public Object nextMeta() throws JSONException {
        char c2;
        while (Character.isWhitespace(c2 = this.next())) {
        }
        switch (c2) {
            case '\u0000': {
                throw this.syntaxError("Misshaped meta tag");
            }
            case '<': {
                return XML.LT;
            }
            case '>': {
                return XML.GT;
            }
            case '/': {
                return XML.SLASH;
            }
            case '=': {
                return XML.EQ;
            }
            case '!': {
                return XML.BANG;
            }
            case '?': {
                return XML.QUEST;
            }
            case '\"': 
            case '\'': {
                char c3 = c2;
                do {
                    if ((c2 = this.next()) != '\u0000') continue;
                    throw this.syntaxError("Unterminated string");
                } while (c2 != c3);
                return Boolean.TRUE;
            }
        }
        while (!Character.isWhitespace(c2 = this.next())) {
            switch (c2) {
                case '\u0000': {
                    throw this.syntaxError("Unterminated string");
                }
                case '!': 
                case '\"': 
                case '\'': 
                case '/': 
                case '<': 
                case '=': 
                case '>': 
                case '?': {
                    this.back();
                    return Boolean.TRUE;
                }
            }
        }
        return Boolean.TRUE;
    }

    public Object nextToken() throws JSONException {
        char c2;
        while (Character.isWhitespace(c2 = this.next())) {
        }
        switch (c2) {
            case '\u0000': {
                throw this.syntaxError("Misshaped element");
            }
            case '<': {
                throw this.syntaxError("Misplaced '<'");
            }
            case '>': {
                return XML.GT;
            }
            case '/': {
                return XML.SLASH;
            }
            case '=': {
                return XML.EQ;
            }
            case '!': {
                return XML.BANG;
            }
            case '?': {
                return XML.QUEST;
            }
            case '\"': 
            case '\'': {
                char c3 = c2;
                StringBuilder stringBuilder = new StringBuilder();
                while (true) {
                    if ((c2 = this.next()) == '\u0000') {
                        throw this.syntaxError("Unterminated string");
                    }
                    if (c2 == c3) {
                        return stringBuilder.toString();
                    }
                    if (c2 == '&') {
                        stringBuilder.append(this.nextEntity(c2));
                        continue;
                    }
                    stringBuilder.append(c2);
                }
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        while (true) {
            stringBuilder.append(c2);
            c2 = this.next();
            if (Character.isWhitespace(c2)) {
                return stringBuilder.toString();
            }
            switch (c2) {
                case '\u0000': {
                    return stringBuilder.toString();
                }
                case '!': 
                case '/': 
                case '=': 
                case '>': 
                case '?': 
                case '[': 
                case ']': {
                    this.back();
                    return stringBuilder.toString();
                }
                case '\"': 
                case '\'': 
                case '<': {
                    throw this.syntaxError("Bad character in a name");
                }
            }
        }
    }

    public void skipPast(String string) {
        char c2;
        int n2;
        int n3 = 0;
        int n4 = string.length();
        char[] cArray = new char[n4];
        for (n2 = 0; n2 < n4; ++n2) {
            c2 = this.next();
            if (c2 == '\u0000') {
                return;
            }
            cArray[n2] = c2;
        }
        while (true) {
            int n5 = n3;
            c2 = '\u0001';
            for (n2 = 0; n2 < n4; ++n2) {
                if (cArray[n5] != string.charAt(n2)) {
                    c2 = '\u0000';
                    break;
                }
                if (++n5 < n4) continue;
                n5 -= n4;
            }
            if (c2 != '\u0000') {
                return;
            }
            c2 = this.next();
            if (c2 == '\u0000') {
                return;
            }
            cArray[n3] = c2;
            if (++n3 < n4) continue;
            n3 -= n4;
        }
    }

    static {
        entity.put("amp", XML.AMP);
        entity.put("apos", XML.APOS);
        entity.put("gt", XML.GT);
        entity.put("lt", XML.LT);
        entity.put("quot", XML.QUOT);
    }
}

