/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.helpers;

import org.slf4j.helpers.Util$ClassContextSecurityManager;

public final class Util {
    private static Util$ClassContextSecurityManager SECURITY_MANAGER;
    private static boolean SECURITY_MANAGER_CREATION_ALREADY_ATTEMPTED;

    private Util() {
    }

    public static String safeGetSystemProperty(String string) {
        if (string == null) {
            throw new IllegalArgumentException("null input");
        }
        String string2 = null;
        try {
            string2 = System.getProperty(string);
        }
        catch (SecurityException securityException) {}
        return string2;
    }

    public static boolean safeGetBooleanSystemProperty(String string) {
        if ((string = Util.safeGetSystemProperty(string)) == null) {
            return false;
        }
        return string.equalsIgnoreCase("true");
    }

    private static Util$ClassContextSecurityManager getSecurityManager() {
        if (SECURITY_MANAGER != null) {
            return SECURITY_MANAGER;
        }
        if (SECURITY_MANAGER_CREATION_ALREADY_ATTEMPTED) {
            return null;
        }
        SECURITY_MANAGER = Util.safeCreateSecurityManager();
        SECURITY_MANAGER_CREATION_ALREADY_ATTEMPTED = true;
        return SECURITY_MANAGER;
    }

    private static Util$ClassContextSecurityManager safeCreateSecurityManager() {
        try {
            return new Util$ClassContextSecurityManager(null);
        }
        catch (SecurityException securityException) {
            return null;
        }
    }

    public static Class<?> getCallingClass() {
        int n2;
        Class<?>[] classArray = Util.getSecurityManager();
        if (classArray == null) {
            return null;
        }
        classArray = classArray.getClassContext();
        String string = Util.class.getName();
        for (n2 = 0; n2 < classArray.length && !string.equals(classArray[n2].getName()); ++n2) {
        }
        if (n2 >= classArray.length || n2 + 2 >= classArray.length) {
            throw new IllegalStateException("Failed to find org.slf4j.helpers.Util or its caller in the stack; this should not happen");
        }
        return classArray[n2 + 2];
    }

    public static final void report(String string, Throwable throwable) {
        System.err.println(string);
        System.err.println("Reported exception:");
        throwable.printStackTrace();
    }

    public static final void report(String string) {
        System.err.println("SLF4J: " + string);
    }

    static {
        SECURITY_MANAGER_CREATION_ALREADY_ATTEMPTED = false;
    }
}

