/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.javafx.internal.offscreen;

import com.teamdev.jxbrowser.browser.event.internal.ImeCompositionCancelled;
import com.teamdev.jxbrowser.browser.internal.BrowserWidget;
import com.teamdev.jxbrowser.browser.internal.Ime;
import com.teamdev.jxbrowser.browser.internal.rpc.ImeTextSpan;
import com.teamdev.jxbrowser.event.Subscription;
import com.teamdev.jxbrowser.internal.ToolkitLibrary;
import com.teamdev.jxbrowser.os.Environment;
import com.teamdev.jxbrowser.view.javafx.internal.offscreen.InputMethodRequests;
import com.teamdev.jxbrowser.view.javafx.internal.window.NativeAwareWindow;
import java.util.ArrayList;
import java.util.function.Supplier;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.input.InputMethodEvent;
import javafx.scene.input.InputMethodHighlight;
import javafx.scene.input.InputMethodTextRun;

final class InputMethods {
    private final BrowserWidget widget;
    private final Supplier<NativeAwareWindow> window;
    private boolean composingImeText;
    private Subscription compositionCancelled;
    private Node node;

    InputMethods(BrowserWidget widget, Supplier<NativeAwareWindow> window) {
        this.widget = widget;
        this.window = window;
    }

    void attach(Node node) {
        this.node = node;
        node.setInputMethodRequests((javafx.scene.input.InputMethodRequests)new InputMethodRequests(this.widget, node));
        node.setOnInputMethodTextChanged(this::handle);
        this.compositionCancelled = this.widget.ime().on(ImeCompositionCancelled.class, event -> this.cancelImeComposition(false));
    }

    void detach() {
        if (this.compositionCancelled != null) {
            this.compositionCancelled.unsubscribe();
        }
        if (this.node != null) {
            this.node.setInputMethodRequests(null);
            this.node.setOnInputMethodTextChanged(null);
            this.node = null;
        }
    }

    boolean isComposingImeText() {
        return this.composingImeText;
    }

    void cancelImeComposition(boolean notifyChromium) {
        if (Environment.isMac() || Environment.isWindows()) {
            Platform.runLater(() -> {
                NativeAwareWindow nativeWindow = this.window.get();
                if (nativeWindow != null) {
                    nativeWindow.findNativeId().ifPresent(arg_0 -> ((ToolkitLibrary)ToolkitLibrary.instance()).endImeComposition(arg_0));
                }
            });
        }
        this.composingImeText = false;
        if (notifyChromium) {
            this.widget.ime().cancelComposition();
        }
    }

    private void handle(InputMethodEvent event) {
        if (!event.getCommitted().isEmpty()) {
            this.widget.ime().commitText(event.getCommitted());
            this.composingImeText = false;
        }
        if (!event.getComposed().isEmpty()) {
            StringBuilder composed = new StringBuilder();
            int start = 0;
            int end = 0;
            boolean currectHighlight = false;
            ArrayList<ImeTextSpan> imeTextSpans = new ArrayList<ImeTextSpan>();
            for (InputMethodTextRun run : event.getComposed()) {
                boolean textPartHighlight;
                InputMethodHighlight highlight = run.getHighlight();
                boolean bl = textPartHighlight = highlight == InputMethodHighlight.SELECTED_CONVERTED || highlight == InputMethodHighlight.SELECTED_RAW;
                if (textPartHighlight != currectHighlight) {
                    if (start != end) {
                        imeTextSpans.add(Ime.createTextSpan((int)start, (int)end, (boolean)currectHighlight));
                    }
                    currectHighlight = textPartHighlight;
                    start = end;
                }
                end += run.getText().length();
                composed.append(run.getText());
            }
            if (start != end) {
                imeTextSpans.add(Ime.createTextSpan((int)start, (int)end, (boolean)currectHighlight));
            }
            this.widget.ime().setComposition(composed.toString(), imeTextSpans);
            this.composingImeText = true;
        }
    }
}

