/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.javafx.internal.offscreen;

import com.teamdev.jxbrowser.view.javafx.internal.window.NativeAwareWindow;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.stage.Stage;
import javafx.stage.Window;

final class SceneTracker
implements ChangeListener<Scene> {
    private final Node node;
    private final Runnable onSceneSwitched;
    private final Runnable onWindowAppeared;
    private final Runnable onWindowDisappeared;
    private final ChangeListener<Number> locationListener;
    private final ChangeListener<Window> windowListener;
    private final ChangeListener<Boolean> iconifiedListener;
    private final ChangeListener<Boolean> showingListener;
    private Scene scene;
    private NativeAwareWindow window;

    private SceneTracker(Node node, Runnable onSceneSwitched, Runnable onWindowAppeared, Runnable onWindowDisappeared, Runnable onWindowMoved, Runnable onWindowMaximized, Runnable onWindowMinimized) {
        this.node = node;
        this.onSceneSwitched = onSceneSwitched;
        this.onWindowAppeared = onWindowAppeared;
        this.onWindowDisappeared = onWindowDisappeared;
        this.showingListener = (o, oldValue, showing) -> {
            if (showing.booleanValue()) {
                onWindowAppeared.run();
            } else {
                onWindowDisappeared.run();
            }
        };
        this.locationListener = (o, oldValue, newValue) -> onWindowMoved.run();
        this.iconifiedListener = (o, oldValue, minimized) -> {
            if (minimized.booleanValue()) {
                onWindowMinimized.run();
            } else {
                onWindowMaximized.run();
            }
        };
        this.windowListener = (o, oldWindow, newWindow) -> {
            if (newWindow != null) {
                this.addWindow((Window)newWindow);
            } else {
                this.removeWindow();
            }
        };
    }

    static Builder newBuilder() {
        return new Builder();
    }

    void attach() {
        this.node.sceneProperty().addListener((ChangeListener)this);
    }

    void detach() {
        this.node.sceneProperty().removeListener((ChangeListener)this);
        if (this.scene != null) {
            this.scene.windowProperty().removeListener(this.windowListener);
            this.scene = null;
        }
        if (this.window != null) {
            this.removeWindow();
        }
    }

    public void changed(ObservableValue<? extends Scene> observable, Scene oldScene, Scene newScene) {
        Platform.runLater(() -> {
            if (this.scene != null) {
                this.scene.windowProperty().removeListener(this.windowListener);
                this.removeWindow();
            }
            this.scene = newScene;
            if (this.scene != null) {
                this.scene.windowProperty().addListener(this.windowListener);
                Window window = this.scene.getWindow();
                if (window != null) {
                    this.addWindow(window);
                }
                this.onSceneSwitched.run();
            }
        });
    }

    NativeAwareWindow window() {
        return this.window;
    }

    void startTrackingMinimizing() {
        if (this.window != null) {
            this.startTrackingMinimizing(this.window.toolkitWindow());
        }
    }

    private void startTrackingMinimizing(Window window) {
        if (window instanceof Stage) {
            ((Stage)window).iconifiedProperty().addListener(this.iconifiedListener);
        }
    }

    void stopTrackingMinimizing() {
        if (this.window != null) {
            this.stopTrackingMinimizing(this.window.toolkitWindow());
        }
    }

    private void stopTrackingMinimizing(Window window) {
        if (window instanceof Stage) {
            ((Stage)window).iconifiedProperty().removeListener(this.iconifiedListener);
        }
    }

    void startTrackingLocation() {
        if (this.window != null) {
            this.startTrackingLocation(this.window.toolkitWindow());
        }
    }

    private void startTrackingLocation(Window window) {
        window.xProperty().addListener(this.locationListener);
        window.yProperty().addListener(this.locationListener);
    }

    void stopTrackingLocation() {
        if (this.window != null) {
            this.stopTrackingLocation(this.window.toolkitWindow());
        }
    }

    private void stopTrackingLocation(Window window) {
        window.xProperty().removeListener(this.locationListener);
        window.yProperty().removeListener(this.locationListener);
    }

    private void addWindow(Window newWindow) {
        this.window = NativeAwareWindow.newInstance(newWindow);
        newWindow.showingProperty().addListener(this.showingListener);
        this.startTrackingLocation(newWindow);
        this.startTrackingMinimizing(newWindow);
        this.onWindowAppeared.run();
    }

    private void removeWindow() {
        if (this.window != null) {
            this.onWindowDisappeared.run();
            Window toolkitWindow = this.window.toolkitWindow();
            toolkitWindow.showingProperty().removeListener(this.showingListener);
            this.stopTrackingLocation(toolkitWindow);
            this.stopTrackingMinimizing(toolkitWindow);
            this.window.detach();
            this.window = null;
        }
    }

    static final class Builder {
        private Runnable onSceneSwitched;
        private Runnable onWindowAppeared;
        private Runnable onWindowDisappeared;
        private Runnable onWindowMoved;
        private Runnable onWindowMaximized;
        private Runnable onWindowMinimized;
        private Node node;

        private Builder() {
        }

        Builder onSceneSwitched(Runnable onSceneSwitched) {
            this.onSceneSwitched = onSceneSwitched;
            return this;
        }

        Builder onWindowMoved(Runnable onWindowMoved) {
            this.onWindowMoved = onWindowMoved;
            return this;
        }

        Builder onWindowMaximized(Runnable onWindowMaximized) {
            this.onWindowMaximized = onWindowMaximized;
            return this;
        }

        Builder onWindowMinimized(Runnable onWindowMinimized) {
            this.onWindowMinimized = onWindowMinimized;
            return this;
        }

        Builder onWindowDisappeared(Runnable onWindowDisappeared) {
            this.onWindowDisappeared = onWindowDisappeared;
            return this;
        }

        Builder onWindowAppeared(Runnable onWindowAppeared) {
            this.onWindowAppeared = onWindowAppeared;
            return this;
        }

        Builder forNode(Node node) {
            this.node = node;
            return this;
        }

        SceneTracker build() {
            return new SceneTracker(this.node, this.onSceneSwitched, this.onWindowAppeared, this.onWindowDisappeared, this.onWindowMoved, this.onWindowMaximized, this.onWindowMinimized);
        }
    }
}

