/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.view.javafx.internal.window;

import com.teamdev.jxbrowser.internal.Lazy;
import com.teamdev.jxbrowser.internal.reflect.Methods;
import com.teamdev.jxbrowser.os.Environment;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import javafx.beans.property.DoubleProperty;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import javafx.scene.Parent;
import javafx.scene.control.Tooltip;
import javafx.stage.PopupWindow;
import javafx.stage.Screen;
import javafx.stage.Window;

final class BeaconWindow {
    private static final int MAX_ORIGIN = 100;
    private static final int MIN_SIZE = 50;
    private static final int MAX_SIZE = 100;
    private static final int MAX_SEARCH_ATTEMPTS = 10;
    private static final Lazy<Tooltip> tooltip = new Lazy(Tooltip::new);

    private BeaconWindow() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Optional<Long> findOwnerId(Window owner) {
        int i = 0;
        if (i < 10) {
            Rectangle2D bounds = BeaconWindow.generateBounds();
            double minX = bounds.getMinX();
            double minY = bounds.getMinY();
            try {
                BeaconWindow.configureTooltip((Tooltip)tooltip.get(), bounds);
                ((Tooltip)tooltip.get()).show(owner, minX, minY);
                Optional<Long> optional = BeaconWindow.findOwnerId(bounds);
                return optional;
            }
            finally {
                ((Tooltip)tooltip.get()).hide();
            }
        }
        return Optional.empty();
    }

    private static Optional<Long> findOwnerId(Rectangle2D bounds) {
        long ownerId = BeaconWindow.findOwnerByBounds((int)bounds.getMinX(), (int)bounds.getMinY(), (int)bounds.getWidth(), (int)bounds.getHeight(), BeaconWindow.scaleFactor());
        return ownerId == 0L ? Optional.empty() : Optional.of(ownerId);
    }

    private static double scaleFactor() {
        Method property = Methods.getMethod(Window.class, (String)"renderScaleXProperty", (Class[])new Class[0]);
        DoubleProperty scaleFactorProperty = (DoubleProperty)Methods.invoke((Object)tooltip.get(), (Method)property, (Object[])new Object[0]);
        return scaleFactorProperty.get();
    }

    private static void configureTooltip(Tooltip tooltip, Rectangle2D bounds) {
        tooltip.setOpacity(0.0);
        tooltip.getStyleClass().clear();
        tooltip.setMinSize(bounds.getWidth(), bounds.getHeight());
        tooltip.setMaxSize(bounds.getWidth(), bounds.getHeight());
        tooltip.setPrefSize(bounds.getWidth(), bounds.getHeight());
        tooltip.setWidth(bounds.getWidth());
        tooltip.setHeight(bounds.getHeight());
        Parent root = tooltip.getScene().getRoot();
        root.getStyleClass().clear();
        tooltip.setAnchorLocation(PopupWindow.AnchorLocation.WINDOW_TOP_LEFT);
    }

    private static Rectangle2D generateBounds() {
        Point2D origin = BeaconWindow.generateOrigin();
        ThreadLocalRandom random = ThreadLocalRandom.current();
        int width = 50 + random.nextInt(50);
        int height = 50 + random.nextInt(50);
        return new Rectangle2D(origin.getX(), origin.getY(), (double)width, (double)height);
    }

    private static Point2D generateOrigin() {
        Point2D result;
        if (Environment.isWindows()) {
            result = Point2D.ZERO;
        } else {
            ThreadLocalRandom random = ThreadLocalRandom.current();
            if (Environment.isMac()) {
                Rectangle2D screenBounds = Screen.getPrimary().getVisualBounds();
                int screenX = (int)screenBounds.getMinX();
                int screenY = (int)screenBounds.getMinY();
                int x = screenX + random.nextInt(100);
                int y = screenY + random.nextInt(100);
                result = new Point2D((double)x, (double)y);
            } else {
                result = new Point2D((double)random.nextInt(100), (double)random.nextInt(100));
            }
        }
        return result;
    }

    private static native long findOwnerByBounds(int var0, int var1, int var2, int var3, double var4);
}

