/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.encoder;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.LoggerContextVO;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.encoder.EncoderBase;
import ch.qos.logback.core.encoder.JsonEscapeUtil;
import java.io.Serializable;
import java.util.Map;
import org.slf4j.event.KeyValuePair;

public class JsonEncoder
extends EncoderBase<ILoggingEvent> {
    static final boolean DO_NOT_ADD_QUOTE_KEY = false;
    static final boolean ADD_QUOTE_KEY = true;
    static int DEFAULT_SIZE = 1024;
    static int DEFAULT_SIZE_WITH_THROWABLE = 1024 << 3;
    static byte[] EMPTY_BYTES = new byte[0];
    public static final String CONTEXT_ATTR_NAME = "context";
    public static final String NAME_ATTR_NAME = "name";
    public static final String BIRTHDATE_ATTR_NAME = "birthdate";
    public static final String CONTEXT_PROPERTIES_ATTR_NAME = "properties";
    public static final String TIMESTAMP_ATTR_NAME = "timestamp";
    public static final String NANOSECONDS_ATTR_NAME = "nanoseconds";
    public static final String SEQUENCE_NUMBER_ATTR_NAME = "sequenceNumber";
    public static final String LEVEL_ATTR_NAME = "level";
    public static final String MARKERS_ATTR_NAME = "markers";
    public static final String THREAD_NAME_ATTR_NAME = "threadName";
    public static final String MDC_ATTR_NAME = "mdc";
    public static final String LOGGER_ATTR_NAME = "loggerName";
    public static final String MESSAGE_ATTR_NAME = "message";
    public static final String FORMATTED_MESSAGE_ATTR_NAME = "formattedMessage";
    public static final String ARGUMENT_ARRAY_ATTR_NAME = "arguments";
    public static final String KEY_VALUE_PAIRS_ATTR_NAME = "kvpList";
    public static final String THROWABLE_ATTR_NAME = "throwable";
    private static final String CYCLIC_THROWABLE_ATTR_NAME = "cyclic";
    public static final String CAUSE_ATTR_NAME = "cause";
    public static final String SUPPRESSED_ATTR_NAME = "suppressed";
    public static final String COMMON_FRAMES_COUNT_ATTR_NAME = "commonFramesCount";
    public static final String CLASS_NAME_ATTR_NAME = "className";
    public static final String METHOD_NAME_ATTR_NAME = "methodName";
    private static final String FILE_NAME_ATTR_NAME = "fileName";
    private static final String LINE_NUMBER_ATTR_NAME = "lineNumber";
    public static final String STEP_ARRAY_NAME_ATTRIBUTE = "stepArray";
    private static final char OPEN_OBJ = '{';
    private static final char CLOSE_OBJ = '}';
    private static final char OPEN_ARRAY = '[';
    private static final char CLOSE_ARRAY = ']';
    private static final char QUOTE = '\"';
    private static final char SP = ' ';
    private static final char ENTRY_SEPARATOR = ':';
    private static final String COL_SP = ": ";
    private static final String QUOTE_COL = "\":";
    private static final char VALUE_SEPARATOR = ',';
    private boolean withSequenceNumber = true;
    private boolean withTimestamp = true;
    private boolean withNanoseconds = true;
    private boolean withLevel = true;
    private boolean withThreadName = true;
    private boolean withLoggerName = true;
    private boolean withContext = true;
    private boolean withMarkers = true;
    private boolean withMDC = true;
    private boolean withKVPList = true;
    private boolean withMessage = true;
    private boolean withArguments = true;
    private boolean withThrowable = true;
    private boolean withFormattedMessage = false;

    @Override
    public byte[] headerBytes() {
        return EMPTY_BYTES;
    }

    @Override
    public byte[] encode(ILoggingEvent iLoggingEvent) {
        int n2 = iLoggingEvent.getThrowableProxy() == null ? DEFAULT_SIZE : DEFAULT_SIZE_WITH_THROWABLE;
        StringBuilder stringBuilder = new StringBuilder(n2);
        stringBuilder.append('{');
        if (this.withSequenceNumber) {
            this.appenderMemberWithLongValue(stringBuilder, SEQUENCE_NUMBER_ATTR_NAME, iLoggingEvent.getSequenceNumber());
        }
        if (this.withTimestamp) {
            this.appendValueSeparator(stringBuilder, this.withSequenceNumber);
            this.appenderMemberWithLongValue(stringBuilder, TIMESTAMP_ATTR_NAME, iLoggingEvent.getTimeStamp());
        }
        if (this.withNanoseconds) {
            this.appendValueSeparator(stringBuilder, this.withSequenceNumber, this.withTimestamp);
            this.appenderMemberWithLongValue(stringBuilder, NANOSECONDS_ATTR_NAME, iLoggingEvent.getNanoseconds());
        }
        if (this.withLevel) {
            this.appendValueSeparator(stringBuilder, this.withNanoseconds, this.withSequenceNumber, this.withTimestamp);
            String string = iLoggingEvent.getLevel() != null ? iLoggingEvent.getLevel().levelStr : "null";
            this.appenderMember(stringBuilder, LEVEL_ATTR_NAME, string);
        }
        if (this.withThreadName) {
            this.appendValueSeparator(stringBuilder, this.withLevel, this.withNanoseconds, this.withSequenceNumber, this.withTimestamp);
            this.appenderMember(stringBuilder, THREAD_NAME_ATTR_NAME, this.jsonEscape(iLoggingEvent.getThreadName()));
        }
        if (this.withLoggerName) {
            this.appendValueSeparator(stringBuilder, this.withThreadName, this.withLevel, this.withNanoseconds, this.withSequenceNumber, this.withTimestamp);
            this.appenderMember(stringBuilder, LOGGER_ATTR_NAME, iLoggingEvent.getLoggerName());
        }
        if (this.withContext) {
            stringBuilder.append(',');
            this.appendLoggerContext(stringBuilder, iLoggingEvent.getLoggerContextVO());
        }
        if (this.withMarkers) {
            this.appendMarkers(stringBuilder, iLoggingEvent);
        }
        if (this.withMDC) {
            this.appendMDC(stringBuilder, iLoggingEvent);
        }
        if (this.withKVPList) {
            this.appendKeyValuePairs(stringBuilder, iLoggingEvent);
        }
        if (this.withMessage) {
            stringBuilder.append(',');
            this.appenderMember(stringBuilder, MESSAGE_ATTR_NAME, this.jsonEscape(iLoggingEvent.getMessage()));
        }
        if (this.withFormattedMessage) {
            stringBuilder.append(',');
            this.appenderMember(stringBuilder, FORMATTED_MESSAGE_ATTR_NAME, this.jsonEscape(iLoggingEvent.getFormattedMessage()));
        }
        if (this.withArguments) {
            this.appendArgumentArray(stringBuilder, iLoggingEvent);
        }
        if (this.withThrowable) {
            this.appendThrowableProxy(stringBuilder, THROWABLE_ATTR_NAME, iLoggingEvent.getThrowableProxy());
        }
        stringBuilder.append('}');
        stringBuilder.append('\n');
        return stringBuilder.toString().getBytes(CoreConstants.UTF_8_CHARSET);
    }

    void appendValueSeparator(StringBuilder stringBuilder, boolean ... blArray) {
        boolean bl2 = false;
        for (boolean bl3 : blArray) {
            if (!bl3) continue;
            bl2 = true;
            break;
        }
        if (bl2) {
            stringBuilder.append(',');
        }
    }

    private void appendLoggerContext(StringBuilder stringBuilder, LoggerContextVO loggerContextVO) {
        stringBuilder.append('\"').append("context\":");
        if (loggerContextVO == null) {
            stringBuilder.append("null");
            return;
        }
        stringBuilder.append('{');
        this.appenderMember(stringBuilder, NAME_ATTR_NAME, this.nullSafeStr(loggerContextVO.getName()));
        stringBuilder.append(',');
        this.appenderMemberWithLongValue(stringBuilder, BIRTHDATE_ATTR_NAME, loggerContextVO.getBirthTime());
        stringBuilder.append(',');
        this.appendMap(stringBuilder, CONTEXT_PROPERTIES_ATTR_NAME, loggerContextVO.getPropertyMap());
        stringBuilder.append('}');
    }

    private void appendMap(StringBuilder stringBuilder, String string, Map<String, String> iterator) {
        stringBuilder.append('\"').append(string).append(QUOTE_COL);
        if (iterator == null) {
            stringBuilder.append("null");
            return;
        }
        stringBuilder.append('{');
        boolean bl2 = false;
        iterator = iterator.entrySet();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            if (bl2) {
                stringBuilder.append(',');
            }
            bl2 = true;
            this.appenderMember(stringBuilder, this.jsonEscapedToString(entry.getKey()), this.jsonEscapedToString(entry.getValue()));
        }
        stringBuilder.append('}');
    }

    private void appendThrowableProxy(StringBuilder stringBuilder, String string, IThrowableProxy iThrowableProxy) {
        this.appendThrowableProxy(stringBuilder, string, iThrowableProxy, true);
    }

    private void appendThrowableProxy(StringBuilder stringBuilder, String iThrowableProxyArray, IThrowableProxy iThrowableProxy, boolean n2) {
        if (n2) {
            stringBuilder.append(',');
        }
        if (iThrowableProxyArray != null) {
            stringBuilder.append('\"').append((String)iThrowableProxyArray).append(QUOTE_COL);
            if (iThrowableProxy == null) {
                stringBuilder.append("null");
                return;
            }
        }
        stringBuilder.append('{');
        this.appenderMember(stringBuilder, CLASS_NAME_ATTR_NAME, this.nullSafeStr(iThrowableProxy.getClassName()));
        stringBuilder.append(',');
        this.appenderMember(stringBuilder, MESSAGE_ATTR_NAME, this.jsonEscape(iThrowableProxy.getMessage()));
        if (iThrowableProxy.isCyclic()) {
            stringBuilder.append(',');
            this.appenderMember(stringBuilder, CYCLIC_THROWABLE_ATTR_NAME, this.jsonEscape("true"));
        }
        stringBuilder.append(',');
        this.appendSTEPArray(stringBuilder, iThrowableProxy.getStackTraceElementProxyArray(), iThrowableProxy.getCommonFrames());
        if (iThrowableProxy.getCommonFrames() != 0) {
            stringBuilder.append(',');
            this.appenderMemberWithIntValue(stringBuilder, COMMON_FRAMES_COUNT_ATTR_NAME, iThrowableProxy.getCommonFrames());
        }
        if ((iThrowableProxyArray = iThrowableProxy.getCause()) != null) {
            this.appendThrowableProxy(stringBuilder, CAUSE_ATTR_NAME, (IThrowableProxy)iThrowableProxyArray);
        }
        if ((iThrowableProxyArray = iThrowableProxy.getSuppressed()) != null && iThrowableProxyArray.length != 0) {
            stringBuilder.append(',');
            stringBuilder.append('\"').append("suppressed\":");
            stringBuilder.append('[');
            boolean bl2 = true;
            for (IThrowableProxy iThrowableProxy2 : iThrowableProxyArray) {
                this.appendThrowableProxy(stringBuilder, null, iThrowableProxy2, !bl2);
                if (!bl2) continue;
                bl2 = false;
            }
            stringBuilder.append(']');
        }
        stringBuilder.append('}');
    }

    private void appendSTEPArray(StringBuilder stringBuilder, StackTraceElementProxy[] stackTraceElementProxyArray, int n2) {
        int n3;
        stringBuilder.append('\"').append("stepArray\":").append('[');
        int n4 = n3 = stackTraceElementProxyArray != null ? stackTraceElementProxyArray.length : 0;
        if (n2 >= n3) {
            n2 = 0;
        }
        for (int i2 = 0; i2 < n3 - n2; ++i2) {
            if (i2 != 0) {
                stringBuilder.append(',');
            }
            Serializable serializable = stackTraceElementProxyArray[i2];
            stringBuilder.append('{');
            serializable = ((StackTraceElementProxy)serializable).getStackTraceElement();
            this.appenderMember(stringBuilder, CLASS_NAME_ATTR_NAME, this.nullSafeStr(((StackTraceElement)serializable).getClassName()));
            stringBuilder.append(',');
            this.appenderMember(stringBuilder, METHOD_NAME_ATTR_NAME, this.nullSafeStr(((StackTraceElement)serializable).getMethodName()));
            stringBuilder.append(',');
            this.appenderMember(stringBuilder, FILE_NAME_ATTR_NAME, this.nullSafeStr(((StackTraceElement)serializable).getFileName()));
            stringBuilder.append(',');
            this.appenderMemberWithIntValue(stringBuilder, LINE_NUMBER_ATTR_NAME, ((StackTraceElement)serializable).getLineNumber());
            stringBuilder.append('}');
        }
        stringBuilder.append(']');
    }

    private void appenderMember(StringBuilder stringBuilder, String string, String string2) {
        stringBuilder.append('\"').append(string).append("\":\"").append(string2).append('\"');
    }

    private void appenderMemberWithIntValue(StringBuilder stringBuilder, String string, int n2) {
        stringBuilder.append('\"').append(string).append(QUOTE_COL).append(n2);
    }

    private void appenderMemberWithLongValue(StringBuilder stringBuilder, String string, long l2) {
        stringBuilder.append('\"').append(string).append(QUOTE_COL).append(l2);
    }

    private void appendKeyValuePairs(StringBuilder stringBuilder, ILoggingEvent object) {
        if ((object = object.getKeyValuePairs()) == null || object.isEmpty()) {
            return;
        }
        stringBuilder.append(',');
        stringBuilder.append('\"').append("kvpList\":").append(' ').append('[');
        int n2 = object.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (i2 != 0) {
                stringBuilder.append(',');
            }
            KeyValuePair keyValuePair = (KeyValuePair)object.get(i2);
            stringBuilder.append('{');
            this.appenderMember(stringBuilder, this.jsonEscapedToString(keyValuePair.key), this.jsonEscapedToString(keyValuePair.value));
            stringBuilder.append('}');
        }
        stringBuilder.append(']');
    }

    private void appendArgumentArray(StringBuilder stringBuilder, ILoggingEvent objectArray) {
        if ((objectArray = objectArray.getArgumentArray()) == null) {
            return;
        }
        stringBuilder.append(',');
        stringBuilder.append('\"').append("arguments\":").append(' ').append('[');
        int n2 = objectArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (i2 != 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append('\"').append(this.jsonEscapedToString(objectArray[i2])).append('\"');
        }
        stringBuilder.append(']');
    }

    private void appendMarkers(StringBuilder stringBuilder, ILoggingEvent object) {
        if ((object = object.getMarkerList()) == null) {
            return;
        }
        stringBuilder.append(',');
        stringBuilder.append('\"').append("markers\":").append(' ').append('[');
        int n2 = object.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (i2 != 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append('\"').append(this.jsonEscapedToString(object.get(i2))).append('\"');
        }
        stringBuilder.append(']');
    }

    private String jsonEscapedToString(Object object) {
        if (object == null) {
            return "null";
        }
        return JsonEscapeUtil.jsonEscapeString(object.toString());
    }

    private String nullSafeStr(String string) {
        if (string == null) {
            return "null";
        }
        return string;
    }

    private String jsonEscape(String string) {
        if (string == null) {
            return "null";
        }
        return JsonEscapeUtil.jsonEscapeString(string);
    }

    private void appendMDC(StringBuilder stringBuilder, ILoggingEvent object) {
        object = object.getMDCPropertyMap();
        stringBuilder.append(',');
        stringBuilder.append('\"').append("mdc\":").append(' ').append('{');
        if (this.isNotEmptyMap((Map)object)) {
            object = object.entrySet();
            int n2 = 0;
            object = object.iterator();
            while (object.hasNext()) {
                Map.Entry entry = (Map.Entry)object.next();
                if (n2 != 0) {
                    stringBuilder.append(',');
                }
                this.appenderMember(stringBuilder, this.jsonEscapedToString(entry.getKey()), this.jsonEscapedToString(entry.getValue()));
                ++n2;
            }
        }
        stringBuilder.append('}');
    }

    boolean isNotEmptyMap(Map map) {
        if (map == null) {
            return false;
        }
        return !map.isEmpty();
    }

    @Override
    public byte[] footerBytes() {
        return EMPTY_BYTES;
    }

    public void setWithSequenceNumber(boolean bl2) {
        this.withSequenceNumber = bl2;
    }

    public void setWithTimestamp(boolean bl2) {
        this.withTimestamp = bl2;
    }

    public void setWithNanoseconds(boolean bl2) {
        this.withNanoseconds = bl2;
    }

    public void setWithLevel(boolean bl2) {
        this.withLevel = bl2;
    }

    public void setWithThreadName(boolean bl2) {
        this.withThreadName = bl2;
    }

    public void setWithLoggerName(boolean bl2) {
        this.withLoggerName = bl2;
    }

    public void setWithContext(boolean bl2) {
        this.withContext = bl2;
    }

    public void setWithMarkers(boolean bl2) {
        this.withMarkers = bl2;
    }

    public void setWithMDC(boolean bl2) {
        this.withMDC = bl2;
    }

    public void setWithKVPList(boolean bl2) {
        this.withKVPList = bl2;
    }

    public void setWithMessage(boolean bl2) {
        this.withMessage = bl2;
    }

    public void setWithArguments(boolean bl2) {
        this.withArguments = bl2;
    }

    public void setWithThrowable(boolean bl2) {
        this.withThrowable = bl2;
    }

    public void setWithFormattedMessage(boolean bl2) {
        this.withFormattedMessage = bl2;
    }
}

