/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.helpers;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import org.slf4j.MDC;

public class MDCInsertingServletFilter
implements Filter {
    public void destroy() {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        this.insertIntoMDC(servletRequest);
        try {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        finally {
            this.clearMDC();
        }
    }

    void insertIntoMDC(ServletRequest servletRequest) {
        MDC.put("req.remoteHost", servletRequest.getRemoteHost());
        if (servletRequest instanceof HttpServletRequest) {
            servletRequest = (HttpServletRequest)servletRequest;
            MDC.put("req.requestURI", servletRequest.getRequestURI());
            StringBuffer stringBuffer = servletRequest.getRequestURL();
            if (stringBuffer != null) {
                MDC.put("req.requestURL", stringBuffer.toString());
            }
            MDC.put("req.method", servletRequest.getMethod());
            MDC.put("req.queryString", servletRequest.getQueryString());
            MDC.put("req.userAgent", servletRequest.getHeader("User-Agent"));
            MDC.put("req.xForwardedFor", servletRequest.getHeader("X-Forwarded-For"));
        }
    }

    void clearMDC() {
        MDC.remove("req.remoteHost");
        MDC.remove("req.requestURI");
        MDC.remove("req.queryString");
        MDC.remove("req.requestURL");
        MDC.remove("req.method");
        MDC.remove("req.userAgent");
        MDC.remove("req.xForwardedFor");
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }
}

