/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.joran;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.PropertiesConfigurator$1;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.JoranConstants;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.model.util.VariableSubstitutionsHelper;
import ch.qos.logback.core.spi.ContextAwareBase;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;

public class PropertiesConfigurator
extends ContextAwareBase {
    static Comparator<String> LENGTH_COMPARATOR = new PropertiesConfigurator$1();
    static final String LOGBACK_PREFIX = "logback";
    static final String LOGBACK_ROOT_LOGGER_PREFIX = "logback.root";
    static final int LOGBACK_ROOT_LOGGER_PREFIX_LENGTH = 12;
    public static final String LOGBACK_LOGGER_PREFIX = "logback.logger.";
    static final int LOGBACK_LOGGER_PREFIX_LENGTH = 15;
    VariableSubstitutionsHelper variableSubstitutionsHelper;

    LoggerContext getLoggerContext() {
        return (LoggerContext)this.getContext();
    }

    @Override
    public void setContext(Context context) {
        super.setContext(context);
    }

    public void doConfigure(URL uRL) throws JoranException {
        try {
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setUseCaches(false);
            InputStream inputStream = uRLConnection.getInputStream();
            this.doConfigure(inputStream);
            return;
        }
        catch (IOException iOException) {
            String string = "Could not open URL [" + String.valueOf(uRL) + "].";
            this.addError(string, iOException);
            throw new JoranException(string, iOException);
        }
    }

    public void doConfigure(File file) throws JoranException {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            this.doConfigure(fileInputStream);
        }
        catch (IOException iOException) {
            throw new JoranException("Failed to load file " + String.valueOf(file), iOException);
        }
    }

    public void doConfigure(String string) throws JoranException {
        this.doConfigure(new File(string));
    }

    public void doConfigure(InputStream inputStream) throws JoranException {
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
        }
        catch (IOException iOException) {
            throw new JoranException("Failed to load from input stream", iOException);
        }
        finally {
            this.close(inputStream);
        }
        this.doConfigure(properties);
    }

    private void close(InputStream inputStream) throws JoranException {
        if (inputStream != null) {
            try {
                inputStream.close();
                return;
            }
            catch (IOException iOException) {
                throw new JoranException("failed to close stream", iOException);
            }
        }
    }

    void doConfigure(Properties map) {
        Map<String, String> map2 = this.extractVariablesMap((Properties)map);
        map = this.extractLogbackInstructionMap((Properties)map);
        this.variableSubstitutionsHelper = new VariableSubstitutionsHelper(this.context, map2);
        this.configureLoggers(map);
        this.configureRootLogger(map);
    }

    void configureRootLogger(Map<String, String> object) {
        if ((object = this.subst(object.get(LOGBACK_ROOT_LOGGER_PREFIX))) != null) {
            this.setLevel("ROOT", (String)object);
        }
    }

    void configureLoggers(Map<String, String> map) {
        for (String string : map.keySet()) {
            if (!string.startsWith(LOGBACK_LOGGER_PREFIX)) continue;
            String string2 = string.substring(LOGBACK_LOGGER_PREFIX_LENGTH);
            string = this.subst(map.get(string));
            this.setLevel(string2, string);
        }
    }

    private void setLevel(String object, String string) {
        Logger logger = this.getLoggerContext().getLogger((String)object);
        if ("INHERITED".equalsIgnoreCase(string) || JoranConstants.NULL.equalsIgnoreCase(string)) {
            if ("ROOT".equalsIgnoreCase((String)object)) {
                this.addError("The level for the ROOT logger cannot be set to NULL or INHERITED. Ignoring.");
                return;
            }
            this.addInfo("Setting level of logger [" + (String)object + "] to null, i.e. INHERITED");
            logger.setLevel(null);
            return;
        }
        object = Level.toLevel(string);
        logger.setLevel((Level)object);
    }

    private Map<String, String> extractVariablesMap(Properties properties) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string : properties.stringPropertyNames()) {
            if (string == null || string.startsWith(LOGBACK_PREFIX)) continue;
            hashMap.put(string, properties.getProperty(string));
        }
        return hashMap;
    }

    private Map<String, String> extractLogbackInstructionMap(Properties properties) {
        TreeMap<String, String> treeMap = new TreeMap<String, String>(LENGTH_COMPARATOR);
        for (String string : properties.stringPropertyNames()) {
            if (string == null || !string.startsWith(LOGBACK_PREFIX)) continue;
            treeMap.put(string, properties.getProperty(string));
        }
        return treeMap;
    }

    public String subst(String string) {
        String string2 = this.variableSubstitutionsHelper.subst(string);
        if (string != null && !string.equals(string2)) {
            this.addInfo("value \"" + string2 + "\" substituted for \"" + string + "\"");
        }
        return string2;
    }
}

