/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.model.processor;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.model.ConfigurationModel;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.processor.ModelHandlerBase;
import ch.qos.logback.core.model.processor.ModelHandlerException;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.core.status.OnConsoleStatusListener;
import ch.qos.logback.core.util.ContextUtil;
import ch.qos.logback.core.util.Duration;
import ch.qos.logback.core.util.OptionHelper;
import ch.qos.logback.core.util.StatusListenerConfigHelper;

public class ConfigurationModelHandler
extends ModelHandlerBase {
    static final Duration SCAN_PERIOD_DEFAULT = Duration.buildByMinutes(1.0);

    public ConfigurationModelHandler(Context context) {
        super(context);
    }

    public static ModelHandlerBase makeInstance(Context context, ModelInterpretationContext modelInterpretationContext) {
        return new ConfigurationModelHandler(context);
    }

    protected Class<ConfigurationModel> getSupportedModelClass() {
        return ConfigurationModel.class;
    }

    @Override
    public void handle(ModelInterpretationContext modelInterpretationContext, Model model) {
        model = (ConfigurationModel)model;
        Object object = OptionHelper.getSystemProperty("logback.debug", null);
        if (object == null) {
            object = modelInterpretationContext.subst(((ConfigurationModel)model).getDebugStr());
        }
        if (!(OptionHelper.isNullOrEmptyOrAllSpaces((String)object) || ((String)object).equalsIgnoreCase(Boolean.FALSE.toString()) || ((String)object).equalsIgnoreCase("null"))) {
            StatusListenerConfigHelper.addOnConsoleListenerInstance(this.context, new OnConsoleStatusListener());
        }
        this.processScanAttrib(modelInterpretationContext, (ConfigurationModel)model);
        object = (LoggerContext)this.context;
        boolean bl2 = OptionHelper.toBoolean(modelInterpretationContext.subst(((ConfigurationModel)model).getPackagingDataStr()), false);
        ((LoggerContext)object).setPackagingDataEnabled(bl2);
        ContextUtil contextUtil = new ContextUtil(this.context);
        contextUtil.addGroovyPackages(((LoggerContext)object).getFrameworkPackages());
    }

    protected void processScanAttrib(ModelInterpretationContext object, ConfigurationModel configurationModel) {
        if (!OptionHelper.isNullOrEmptyOrAllSpaces((String)(object = ((ModelInterpretationContext)object).subst(configurationModel.getScanStr()))) && !"false".equalsIgnoreCase((String)object)) {
            this.addInfo("Skipping ReconfigureOnChangeTask registration");
        }
    }

    protected void postProcessScanAttrib(ModelInterpretationContext modelInterpretationContext, ConfigurationModel configurationModel) {
    }

    @Override
    public void postHandle(ModelInterpretationContext modelInterpretationContext, Model model) throws ModelHandlerException {
        ConfigurationModel cfr_ignored_0 = (ConfigurationModel)model;
    }
}

