/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.model.processor;

import ch.qos.logback.classic.joran.ReconfigureOnChangeTask;
import ch.qos.logback.classic.model.ConfigurationModel;
import ch.qos.logback.classic.model.processor.ConfigurationModelHandler;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.ConfigurationWatchList;
import ch.qos.logback.core.joran.util.ConfigurationWatchListUtil;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.processor.ModelHandlerBase;
import ch.qos.logback.core.model.processor.ModelHandlerException;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.core.spi.ConfigurationEvent;
import ch.qos.logback.core.util.Duration;
import ch.qos.logback.core.util.OptionHelper;
import java.util.concurrent.TimeUnit;

public class ConfigurationModelHandlerFull
extends ConfigurationModelHandler {
    public static String FAILED_WATCH_PREDICATE_MESSAGE_1 = "Missing watchable .xml or .properties files.";
    public static String FAILED_WATCH_PREDICATE_MESSAGE_2 = "Watching .xml files requires that the main configuration file is reachable as a URL";

    public ConfigurationModelHandlerFull(Context context) {
        super(context);
    }

    public static ModelHandlerBase makeInstance2(Context context, ModelInterpretationContext modelInterpretationContext) {
        return new ConfigurationModelHandlerFull(context);
    }

    @Override
    protected void processScanAttrib(ModelInterpretationContext modelInterpretationContext, ConfigurationModel configurationModel) {
    }

    @Override
    public void postHandle(ModelInterpretationContext contextAwareBase, Model model) throws ModelHandlerException {
        model = (ConfigurationModel)model;
        this.postProcessScanAttrib((ModelInterpretationContext)contextAwareBase, (ConfigurationModel)model);
        contextAwareBase = ConfigurationWatchListUtil.getConfigurationWatchList(this.getContext());
        if (contextAwareBase != null) {
            try {
                this.addInfo("Main configuration file URL: " + String.valueOf(((ConfigurationWatchList)contextAwareBase).getMainURL()));
                this.addInfo("FileWatchList= {" + ((ConfigurationWatchList)contextAwareBase).getFileWatchListAsStr() + "}");
                this.addInfo("URLWatchList= {" + ((ConfigurationWatchList)contextAwareBase).getUrlWatchListAsStr() + "}");
                return;
            }
            catch (NoSuchMethodError noSuchMethodError) {
                this.addWarn("It looks like the version of logback-classic is more recent than");
                this.addWarn("the version of logback-core. Please align the two versions.");
            }
        }
    }

    @Override
    protected void postProcessScanAttrib(ModelInterpretationContext object, ConfigurationModel configurationModel) {
        String string = ((ModelInterpretationContext)object).subst(configurationModel.getScanStr());
        object = ((ModelInterpretationContext)object).subst(configurationModel.getScanPeriodStr());
        this.detachedPostProcess(string, (String)object);
    }

    public void detachedPostProcess(String scheduledFuture, String object) {
        if (!OptionHelper.isNullOrEmptyOrAllSpaces((String)((Object)scheduledFuture)) && !"false".equalsIgnoreCase((String)((Object)scheduledFuture))) {
            scheduledFuture = this.context.getScheduledExecutorService();
            boolean bl2 = ConfigurationWatchListUtil.watchPredicateFulfilled(this.context);
            if (!bl2) {
                this.addWarn(FAILED_WATCH_PREDICATE_MESSAGE_1);
                this.addWarn(FAILED_WATCH_PREDICATE_MESSAGE_2);
                return;
            }
            ReconfigureOnChangeTask reconfigureOnChangeTask = new ReconfigureOnChangeTask();
            reconfigureOnChangeTask.setContext(this.context);
            this.addInfo("Registering a new ReconfigureOnChangeTask " + String.valueOf(reconfigureOnChangeTask));
            this.context.fireConfigurationEvent(ConfigurationEvent.newConfigurationChangeDetectorRegisteredEvent(reconfigureOnChangeTask));
            object = this.getDurationOfScanPeriodAttribute((String)object, SCAN_PERIOD_DEFAULT);
            ConfigurationModelHandlerFull configurationModelHandlerFull = this;
            configurationModelHandlerFull.addInfo("Will scan for changes in [" + String.valueOf(ConfigurationWatchListUtil.getConfigurationWatchList(configurationModelHandlerFull.context)) + "] ");
            this.addInfo("Setting ReconfigureOnChangeTask scanning period to " + String.valueOf(object));
            scheduledFuture = scheduledFuture.scheduleAtFixedRate(reconfigureOnChangeTask, ((Duration)object).getMilliseconds(), ((Duration)object).getMilliseconds(), TimeUnit.MILLISECONDS);
            reconfigureOnChangeTask.setScheduledFuture(scheduledFuture);
            this.context.addScheduledFuture(scheduledFuture);
        }
    }

    private Duration getDurationOfScanPeriodAttribute(String string, Duration duration) {
        Duration duration2 = null;
        if (!OptionHelper.isNullOrEmptyOrAllSpaces(string)) {
            try {
                duration2 = Duration.valueOf(string);
            }
            catch (IllegalArgumentException | IllegalStateException runtimeException) {
                this.addWarn("Failed to parse 'scanPeriod' attribute [" + string + "]", runtimeException);
            }
        }
        if (duration2 == null) {
            this.addInfo("No 'scanPeriod' specified. Defaulting to " + duration.toString());
            duration2 = duration;
        }
        return duration2;
    }
}

