/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.model.processor;

import ch.qos.logback.classic.model.ReceiverModel;
import ch.qos.logback.classic.net.ReceiverBase;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.model.ComponentModel;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.processor.ModelHandlerBase;
import ch.qos.logback.core.model.processor.ModelHandlerException;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.core.util.OptionHelper;

public class ReceiverModelHandler
extends ModelHandlerBase {
    private ReceiverBase receiver;
    private boolean inError;

    public ReceiverModelHandler(Context context) {
        super(context);
    }

    public static ModelHandlerBase makeInstance(Context context, ModelInterpretationContext modelInterpretationContext) {
        return new ReceiverModelHandler(context);
    }

    protected Class<ReceiverModel> getSupportedModelClass() {
        return ReceiverModel.class;
    }

    @Override
    public void handle(ModelInterpretationContext modelInterpretationContext, Model object) throws ModelHandlerException {
        object = (ReceiverModel)object;
        if (OptionHelper.isNullOrEmptyOrAllSpaces((String)(object = ((ComponentModel)object).getClassName()))) {
            this.addError("Missing class name for receiver. ");
            this.inError = true;
            return;
        }
        object = modelInterpretationContext.getImport((String)object);
        try {
            this.addInfo("About to instantiate receiver of type [" + (String)object + "]");
            this.receiver = (ReceiverBase)OptionHelper.instantiateByClassName((String)object, ReceiverBase.class, this.context);
            this.receiver.setContext(this.context);
            modelInterpretationContext.pushObject(this.receiver);
            return;
        }
        catch (Exception exception) {
            this.inError = true;
            this.addError("Could not create a receiver of type [" + (String)object + "].", exception);
            throw new ModelHandlerException(exception);
        }
    }

    @Override
    public void postHandle(ModelInterpretationContext modelInterpretationContext, Model object) throws ModelHandlerException {
        if (this.inError) {
            return;
        }
        object = modelInterpretationContext.peekObject();
        if (object != this.receiver) {
            this.addWarn("The object at the of the stack is not the receiver pushed earlier.");
            return;
        }
        modelInterpretationContext.popObject();
        this.addInfo("Registering receiver with context.");
        modelInterpretationContext.getContext().register(this.receiver);
        this.receiver.start();
    }
}

