/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.pattern;

import ch.qos.logback.classic.pattern.ClassicConverter;
import ch.qos.logback.classic.pattern.KeyValuePairConverter$ValueQuoteSpecification;
import ch.qos.logback.classic.spi.ILoggingEvent;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.event.KeyValuePair;

public class MaskedKeyValuePairConverter
extends ClassicConverter {
    public static final String MASK = "XXX";
    List<String> optionList;
    List<String> maskList = new ArrayList<String>();
    KeyValuePairConverter$ValueQuoteSpecification valueQuoteSpec = KeyValuePairConverter$ValueQuoteSpecification.DOUBLE;

    @Override
    public void start() {
        this.optionList = this.getOptionList();
        MaskedKeyValuePairConverter maskedKeyValuePairConverter = this;
        KeyValuePairConverter$ValueQuoteSpecification keyValuePairConverter$ValueQuoteSpecification = maskedKeyValuePairConverter.extractSpec(maskedKeyValuePairConverter.optionList);
        if (keyValuePairConverter$ValueQuoteSpecification == null) {
            this.maskList = this.optionList;
        } else {
            this.valueQuoteSpec = keyValuePairConverter$ValueQuoteSpecification;
            this.maskList = this.optionList.subList(1, this.optionList.size());
        }
        MaskedKeyValuePairConverter maskedKeyValuePairConverter2 = this;
        maskedKeyValuePairConverter2.checkMaskListForExtraQuoteSpecs(maskedKeyValuePairConverter2.maskList);
        super.start();
    }

    private void checkMaskListForExtraQuoteSpecs(List<String> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        if (list.contains("DOUBLE")) {
            this.addWarn("quote spec DOUBLE found in the wrong order");
        }
        if (list.contains("SINGLE")) {
            this.addWarn("extra quote spec SINGLE found in the wrong order");
        }
        if (list.contains("NONE")) {
            this.addWarn("extra quote spec NONE found in the wrong order");
        }
    }

    KeyValuePairConverter$ValueQuoteSpecification extractSpec(List<String> object) {
        if (object == null || object.isEmpty()) {
            return null;
        }
        if ("DOUBLE".equalsIgnoreCase((String)(object = object.get(0)))) {
            return KeyValuePairConverter$ValueQuoteSpecification.DOUBLE;
        }
        if ("SINGLE".equalsIgnoreCase((String)object)) {
            return KeyValuePairConverter$ValueQuoteSpecification.SINGLE;
        }
        if ("NONE".equalsIgnoreCase((String)object)) {
            return KeyValuePairConverter$ValueQuoteSpecification.NONE;
        }
        return null;
    }

    @Override
    public String convert(ILoggingEvent object) {
        if ((object = object.getKeyValuePairs()) == null || object.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < object.size(); ++i2) {
            KeyValuePair keyValuePair = (KeyValuePair)object.get(i2);
            if (i2 != 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(String.valueOf(keyValuePair.key));
            stringBuilder.append('=');
            Character c2 = this.valueQuoteSpec.asChar();
            if (c2 != null) {
                stringBuilder.append(c2);
            }
            if (this.maskList.contains(keyValuePair.key)) {
                stringBuilder.append(MASK);
            } else {
                stringBuilder.append(String.valueOf(keyValuePair.value));
            }
            if (c2 == null) continue;
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }
}

