/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.spi;

import ch.qos.logback.classic.spi.ClassPackagingData;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.classic.spi.ThrowableProxy;
import ch.qos.logback.core.CoreConstants;

public class ThrowableProxyUtil {
    public static final int REGULAR_EXCEPTION_INDENT = 1;
    public static final int SUPPRESSED_EXCEPTION_INDENT = 1;
    private static final int BUILDER_CAPACITY = 2048;

    public static void build(ThrowableProxy throwableProxy, Throwable stackTraceElementArray, ThrowableProxy throwableProxy2) {
        stackTraceElementArray = stackTraceElementArray.getStackTrace();
        int n2 = -1;
        if (throwableProxy2 != null) {
            n2 = ThrowableProxyUtil.findNumberOfCommonFrames(stackTraceElementArray, throwableProxy2.getStackTraceElementProxyArray());
        }
        throwableProxy.commonFrames = n2;
        throwableProxy.stackTraceElementProxyArray = ThrowableProxyUtil.steArrayToStepArray(stackTraceElementArray);
    }

    static StackTraceElementProxy[] steArrayToStepArray(StackTraceElement[] stackTraceElementArray) {
        if (stackTraceElementArray == null) {
            return new StackTraceElementProxy[0];
        }
        StackTraceElementProxy[] stackTraceElementProxyArray = new StackTraceElementProxy[stackTraceElementArray.length];
        for (int i2 = 0; i2 < stackTraceElementProxyArray.length; ++i2) {
            stackTraceElementProxyArray[i2] = new StackTraceElementProxy(stackTraceElementArray[i2]);
        }
        return stackTraceElementProxyArray;
    }

    static int findNumberOfCommonFrames(StackTraceElement[] stackTraceElementArray, StackTraceElementProxy[] stackTraceElementProxyArray) {
        StackTraceElement stackTraceElement;
        StackTraceElement stackTraceElement2;
        if (stackTraceElementProxyArray == null || stackTraceElementArray == null) {
            return 0;
        }
        int n2 = stackTraceElementArray.length - 1;
        int n3 = 0;
        for (int i2 = stackTraceElementProxyArray.length - 1; n2 >= 0 && i2 >= 0 && (stackTraceElement2 = stackTraceElementArray[n2]).equals(stackTraceElement = stackTraceElementProxyArray[i2].ste); --n2, --i2) {
            ++n3;
        }
        return n3;
    }

    public static String asString(IThrowableProxy iThrowableProxy) {
        StringBuilder stringBuilder = new StringBuilder(2048);
        ThrowableProxyUtil.recursiveAppend(stringBuilder, null, 1, iThrowableProxy);
        return stringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     */
    private static void recursiveAppend(StringBuilder stringBuilder, String object, int n2, IThrowableProxy iThrowableProxy) {
        IThrowableProxy iThrowableProxy2;
        while (iThrowableProxy2 != null) {
            void var2_7;
            void var1_2;
            ThrowableProxyUtil.subjoinFirstLine(stringBuilder, (String)var1_2, (int)var2_7, iThrowableProxy2);
            stringBuilder.append(CoreConstants.LINE_SEPARATOR);
            ThrowableProxyUtil.subjoinSTEPArray(stringBuilder, (int)var2_7, iThrowableProxy2);
            IThrowableProxy[] iThrowableProxyArray = iThrowableProxy2.getSuppressed();
            if (iThrowableProxyArray != null) {
                IThrowableProxy[] iThrowableProxyArray2 = iThrowableProxyArray;
                int n3 = iThrowableProxyArray.length;
                for (int i2 = 0; i2 < n3; ++i2) {
                    IThrowableProxy iThrowableProxy3 = iThrowableProxyArray2[i2];
                    ThrowableProxyUtil.recursiveAppend(stringBuilder, "Suppressed: ", (int)(var2_7 + true), iThrowableProxy3);
                }
            }
            iThrowableProxy2 = iThrowableProxy2.getCause();
            String string = "Caused by: ";
        }
        return;
    }

    public static void indent(StringBuilder stringBuilder, int n2) {
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuilder.append('\t');
        }
    }

    private static void subjoinFirstLine(StringBuilder stringBuilder, String string, int n2, IThrowableProxy iThrowableProxy) {
        ThrowableProxyUtil.indent(stringBuilder, n2 - 1);
        if (string != null) {
            stringBuilder.append(string);
        }
        ThrowableProxyUtil.subjoinExceptionMessage(stringBuilder, iThrowableProxy);
    }

    public static void subjoinPackagingData(StringBuilder stringBuilder, StackTraceElementProxy serializable) {
        if (serializable != null && (serializable = ((StackTraceElementProxy)serializable).getClassPackagingData()) != null) {
            if (!((ClassPackagingData)serializable).isExact()) {
                stringBuilder.append(" ~[");
            } else {
                stringBuilder.append(" [");
            }
            stringBuilder.append(((ClassPackagingData)serializable).getCodeLocation()).append(':').append(((ClassPackagingData)serializable).getVersion()).append(']');
        }
    }

    public static void subjoinSTEP(StringBuilder stringBuilder, StackTraceElementProxy stackTraceElementProxy) {
        stringBuilder.append(stackTraceElementProxy.toString());
        ThrowableProxyUtil.subjoinPackagingData(stringBuilder, stackTraceElementProxy);
    }

    public static void subjoinSTEPArray(StringBuilder stringBuilder, IThrowableProxy iThrowableProxy) {
        ThrowableProxyUtil.subjoinSTEPArray(stringBuilder, 1, iThrowableProxy);
    }

    public static void subjoinSTEPArray(StringBuilder stringBuilder, int n2, IThrowableProxy iThrowableProxy) {
        StackTraceElementProxy[] stackTraceElementProxyArray = iThrowableProxy.getStackTraceElementProxyArray();
        int n3 = iThrowableProxy.getCommonFrames();
        for (int i2 = 0; i2 < stackTraceElementProxyArray.length - n3; ++i2) {
            StackTraceElementProxy stackTraceElementProxy = stackTraceElementProxyArray[i2];
            ThrowableProxyUtil.indent(stringBuilder, n2);
            ThrowableProxyUtil.subjoinSTEP(stringBuilder, stackTraceElementProxy);
            stringBuilder.append(CoreConstants.LINE_SEPARATOR);
        }
        if (n3 > 0) {
            ThrowableProxyUtil.indent(stringBuilder, n2);
            stringBuilder.append("... ").append(n3).append(" common frames omitted").append(CoreConstants.LINE_SEPARATOR);
        }
    }

    public static void subjoinFirstLine(StringBuilder stringBuilder, IThrowableProxy iThrowableProxy) {
        int n2 = iThrowableProxy.getCommonFrames();
        if (n2 > 0) {
            stringBuilder.append("Caused by: ");
        }
        ThrowableProxyUtil.subjoinExceptionMessage(stringBuilder, iThrowableProxy);
    }

    public static void subjoinFirstLineRootCauseFirst(StringBuilder stringBuilder, IThrowableProxy iThrowableProxy) {
        if (iThrowableProxy.getCause() != null) {
            stringBuilder.append("Wrapped by: ");
        }
        ThrowableProxyUtil.subjoinExceptionMessage(stringBuilder, iThrowableProxy);
    }

    private static void subjoinExceptionMessage(StringBuilder stringBuilder, IThrowableProxy iThrowableProxy) {
        if (iThrowableProxy.isCyclic()) {
            stringBuilder.append("[CIRCULAR REFERENCE: ").append(iThrowableProxy.getClassName()).append(": ").append(iThrowableProxy.getMessage()).append(']');
            return;
        }
        stringBuilder.append(iThrowableProxy.getClassName()).append(": ").append(iThrowableProxy.getMessage());
    }
}

