/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.turbo;

import java.util.LinkedHashMap;
import java.util.Map;

class LRUMessageCache
extends LinkedHashMap<String, Integer> {
    private static final long serialVersionUID = 1L;
    final int cacheSize;

    LRUMessageCache(int n2) {
        super((int)((float)n2 * 1.3333334f), 0.75f, true);
        if (n2 <= 0) {
            throw new IllegalArgumentException("Cache size cannot be smaller than 1");
        }
        this.cacheSize = n2;
    }

    int getMessageCountAndThenIncrement(String string) {
        Integer n2;
        if (string == null) {
            return 0;
        }
        LRUMessageCache lRUMessageCache = this;
        synchronized (lRUMessageCache) {
            n2 = (Integer)super.get(string);
            n2 = n2 == null ? Integer.valueOf(0) : Integer.valueOf(n2 + 1);
            super.put(string, n2);
        }
        return n2;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<String, Integer> entry) {
        return this.size() > this.cacheSize;
    }

    @Override
    public synchronized void clear() {
        super.clear();
    }
}

