/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core;

import ch.qos.logback.core.OutputStreamAppender;
import ch.qos.logback.core.recovery.ResilientFileOutputStream;
import ch.qos.logback.core.recovery.ResilientOutputStreamBase;
import ch.qos.logback.core.util.ContextUtil;
import ch.qos.logback.core.util.FileSize;
import ch.qos.logback.core.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.Map;

public class FileAppender<E>
extends OutputStreamAppender<E> {
    public static final long DEFAULT_BUFFER_SIZE = 8192L;
    protected static String COLLISION_WITH_EARLIER_APPENDER_URL = "https://logback.qos.ch/codes.html#earlier_fa_collision";
    protected boolean append = true;
    protected String fileName = null;
    private boolean prudent = false;
    private FileSize bufferSize = new FileSize(8192L);

    public void setFile(String string) {
        if (string == null) {
            this.fileName = string;
            return;
        }
        this.fileName = string.trim();
    }

    public boolean isAppend() {
        return this.append;
    }

    public final String rawFileProperty() {
        return this.fileName;
    }

    public String getFile() {
        return this.fileName;
    }

    @Override
    public void start() {
        int n2 = 0;
        if (this.getFile() != null) {
            FileAppender fileAppender = this;
            fileAppender.addInfo("File property is set to [" + fileAppender.fileName + "]");
            if (this.prudent && !this.isAppend()) {
                this.setAppend(true);
                this.addWarn("Setting \"Append\" property to true on account of \"Prudent\" mode");
            }
            if (this.checkForFileCollisionInPreviousFileAppenders()) {
                this.addError("Collisions detected with FileAppender/RollingAppender instances defined earlier. Aborting.");
                this.addError("For more information, please visit " + COLLISION_WITH_EARLIER_APPENDER_URL);
                ++n2;
            } else {
                try {
                    FileAppender fileAppender2 = this;
                    fileAppender2.openFile(fileAppender2.getFile());
                }
                catch (IOException iOException) {
                    ++n2;
                    FileAppender fileAppender3 = this;
                    fileAppender3.addError("openFile(" + fileAppender3.fileName + "," + this.append + ") call failed.", iOException);
                }
            }
        } else {
            ++n2;
            FileAppender fileAppender = this;
            fileAppender.addError("\"File\" property not set for appender named [" + fileAppender.name + "].");
        }
        if (n2 == 0) {
            super.start();
        }
    }

    @Override
    public void stop() {
        if (!this.isStarted()) {
            return;
        }
        super.stop();
        Map<String, String> map = ContextUtil.getFilenameCollisionMap(this.context);
        if (map == null || this.getName() == null) {
            return;
        }
        map.remove(this.getName());
    }

    protected boolean checkForFileCollisionInPreviousFileAppenders() {
        boolean bl2 = false;
        if (this.fileName == null) {
            return false;
        }
        Map map = (Map)this.context.getObject("FA_FILENAMES_MAP");
        if (map == null) {
            return false;
        }
        for (Map.Entry entry : map.entrySet()) {
            if (!this.fileName.equals(entry.getValue())) continue;
            this.addErrorForCollision("File", (String)entry.getValue(), (String)entry.getKey());
            bl2 = true;
        }
        if (this.name != null) {
            map.put(this.getName(), this.fileName);
        }
        return bl2;
    }

    protected void addErrorForCollision(String string, String string2, String string3) {
        this.addError("'" + string + "' option has the same value \"" + string2 + "\" as that given for appender [" + string3 + "] defined earlier.");
    }

    public void openFile(String object) throws IOException {
        this.streamWriteLock.lock();
        try {
            object = new File((String)object);
            boolean bl2 = FileUtil.createMissingParentDirectories((File)object);
            if (!bl2) {
                this.addError("Failed to create parent directories for [" + ((File)object).getAbsolutePath() + "]");
            }
            object = new ResilientFileOutputStream((File)object, this.append, this.bufferSize.getSize());
            ((ResilientOutputStreamBase)object).setContext(this.context);
            this.setOutputStream((OutputStream)object);
            return;
        }
        finally {
            this.streamWriteLock.unlock();
        }
    }

    public boolean isPrudent() {
        return this.prudent;
    }

    public void setPrudent(boolean bl2) {
        this.prudent = bl2;
    }

    public void setAppend(boolean bl2) {
        this.append = bl2;
    }

    public void setBufferSize(FileSize fileSize) {
        this.addInfo("Setting bufferSize to [" + fileSize.toString() + "]");
        this.bufferSize = fileSize;
    }

    @Override
    protected void writeOut(E e2) throws IOException {
        if (this.prudent) {
            this.safeWriteOut(e2);
            return;
        }
        super.writeOut(e2);
    }

    private void safeWriteOut(E object) {
        byte[] byArray = this.encoder.encode(object);
        object = byArray;
        if (byArray == null || ((E)object).length == 0) {
            return;
        }
        this.streamWriteLock.lock();
        try {
            this.safeWriteBytes((byte[])object);
            return;
        }
        finally {
            this.streamWriteLock.unlock();
        }
    }

    private void safeWriteBytes(byte[] byArray) {
        block8: {
            ResilientFileOutputStream resilientFileOutputStream = (ResilientFileOutputStream)this.getOutputStream();
            FileChannel fileChannel = resilientFileOutputStream.getChannel();
            if (fileChannel == null) {
                return;
            }
            boolean bl2 = Thread.interrupted();
            FileLock fileLock = null;
            try {
                fileLock = fileChannel.lock();
                long l2 = fileChannel.position();
                long l3 = fileChannel.size();
                if (l3 != l2) {
                    fileChannel.position(l3);
                }
                this.writeByteArrayToOutputStreamWithPossibleFlush(byArray);
                this.releaseFileLock(fileLock);
                if (bl2) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
            catch (IOException iOException) {
                resilientFileOutputStream.postIOFailure(iOException);
                return;
            }
            finally {
                this.releaseFileLock(fileLock);
                if (!bl2) break block8;
                Thread.currentThread().interrupt();
            }
        }
    }

    private void releaseFileLock(FileLock fileLock) {
        if (fileLock != null && fileLock.isValid()) {
            try {
                fileLock.release();
                return;
            }
            catch (IOException iOException) {
                this.addError("failed to release lock", iOException);
            }
        }
    }
}

