/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core;

import ch.qos.logback.core.Layout;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.encoder.LayoutWrappingEncoder;
import ch.qos.logback.core.spi.DeferredProcessingAware;
import ch.qos.logback.core.status.ErrorStatus;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.locks.ReentrantLock;

public class OutputStreamAppender<E>
extends UnsynchronizedAppenderBase<E> {
    protected Encoder<E> encoder;
    protected final ReentrantLock streamWriteLock = new ReentrantLock(false);
    private OutputStream outputStream;
    boolean immediateFlush = true;

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    @Override
    public void start() {
        int n2 = 0;
        if (this.encoder == null) {
            this.addStatus(new ErrorStatus("No encoder set for the appender named \"" + this.name + "\".", this));
            ++n2;
        }
        if (this.outputStream == null) {
            this.addStatus(new ErrorStatus("No output stream set for the appender named \"" + this.name + "\".", this));
            ++n2;
        }
        if (this.encoder == null) {
            this.addWarn("Encoder has not been set. Cannot invoke its init method.");
            ++n2;
        }
        if (n2 == 0) {
            super.start();
            this.encoderInit();
        }
    }

    public void setLayout(Layout<E> layout) {
        this.addWarn("This appender no longer admits a layout as a sub-component, set an encoder instead.");
        this.addWarn("To ensure compatibility, wrapping your layout in LayoutWrappingEncoder.");
        this.addWarn("See also https://logback.qos.ch/codes.html#layoutInsteadOfEncoder for details");
        LayoutWrappingEncoder<E> layoutWrappingEncoder = new LayoutWrappingEncoder<E>();
        layoutWrappingEncoder.setLayout(layout);
        layoutWrappingEncoder.setContext(this.context);
        this.encoder = layoutWrappingEncoder;
    }

    @Override
    protected void append(E e2) {
        if (!this.isStarted()) {
            return;
        }
        this.subAppend(e2);
    }

    @Override
    public void stop() {
        if (!this.isStarted()) {
            return;
        }
        this.streamWriteLock.lock();
        try {
            this.closeOutputStream();
            super.stop();
            return;
        }
        finally {
            this.streamWriteLock.unlock();
        }
    }

    protected void closeOutputStream() {
        if (this.outputStream != null) {
            try {
                this.encoderClose();
                this.outputStream.close();
                this.outputStream = null;
                return;
            }
            catch (IOException iOException) {
                this.addStatus(new ErrorStatus("Could not close output stream for OutputStreamAppender.", this, iOException));
            }
        }
    }

    void encoderClose() {
        if (this.encoder != null && this.outputStream != null) {
            try {
                byte[] byArray = this.encoder.footerBytes();
                this.writeBytes(byArray);
                return;
            }
            catch (IOException iOException) {
                this.started = false;
                this.addStatus(new ErrorStatus("Failed to write footer for appender named [" + this.name + "].", this, iOException));
            }
        }
    }

    public void setOutputStream(OutputStream outputStream) {
        this.streamWriteLock.lock();
        try {
            this.closeOutputStream();
            this.outputStream = outputStream;
            if (this.isStarted()) {
                this.encoderInit();
            }
            return;
        }
        finally {
            this.streamWriteLock.unlock();
        }
    }

    void encoderInit() {
        if (this.encoder != null && this.outputStream != null) {
            try {
                byte[] byArray = this.encoder.headerBytes();
                this.writeBytes(byArray);
                return;
            }
            catch (IOException iOException) {
                this.started = false;
                this.addStatus(new ErrorStatus("Failed to initialize encoder for appender named [" + this.name + "].", this, iOException));
            }
        }
    }

    protected void writeOut(E object) throws IOException {
        object = this.encoder.encode(object);
        this.writeBytes((byte[])object);
    }

    private void writeBytes(byte[] byArray) throws IOException {
        if (byArray == null || byArray.length == 0) {
            return;
        }
        this.streamWriteLock.lock();
        try {
            if (this.isStarted()) {
                this.writeByteArrayToOutputStreamWithPossibleFlush(byArray);
                this.updateByteCount(byArray);
            }
            return;
        }
        finally {
            this.streamWriteLock.unlock();
        }
    }

    protected void updateByteCount(byte[] byArray) {
    }

    protected final void writeByteArrayToOutputStreamWithPossibleFlush(byte[] byArray) throws IOException {
        this.outputStream.write(byArray);
        if (this.immediateFlush) {
            this.outputStream.flush();
        }
    }

    protected void subAppend(E e2) {
        if (!this.isStarted()) {
            return;
        }
        try {
            if (e2 instanceof DeferredProcessingAware) {
                ((DeferredProcessingAware)e2).prepareForDeferredProcessing();
            }
            this.writeOut(e2);
            return;
        }
        catch (IOException iOException) {
            this.started = false;
            this.addStatus(new ErrorStatus("IO failure in appender", this, iOException));
            return;
        }
    }

    public Encoder<E> getEncoder() {
        return this.encoder;
    }

    public void setEncoder(Encoder<E> encoder) {
        this.encoder = encoder;
    }

    public boolean isImmediateFlush() {
        return this.immediateFlush;
    }

    public void setImmediateFlush(boolean bl2) {
        this.immediateFlush = bl2;
    }
}

