/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.encoder;

public class JsonEscapeUtil {
    protected static final char[] HEXADECIMALS_TABLE = "0123456789ABCDEF".toCharArray();
    static final int ESCAPE_CODES_COUNT = 32;
    static final String[] ESCAPE_CODES = new String[32];

    private static String _computeEscapeCodeBelowASCII32(char c2) {
        if (c2 > ' ') {
            throw new IllegalArgumentException("input must be less than 32");
        }
        StringBuilder stringBuilder = new StringBuilder(6);
        stringBuilder.append("\\u00");
        int n2 = c2 >> 4;
        stringBuilder.append(HEXADECIMALS_TABLE[n2]);
        c2 = (char)(c2 & 0xF);
        stringBuilder.append(HEXADECIMALS_TABLE[c2]);
        return stringBuilder.toString();
    }

    static String getObligatoryEscapeCode(char c2) {
        if (c2 < ' ') {
            return ESCAPE_CODES[c2];
        }
        if (c2 == '\"') {
            return "\\\"";
        }
        if (c2 == '/') {
            return "\\/";
        }
        if (c2 == '\\') {
            return "\\\\";
        }
        return null;
    }

    public static String jsonEscapeString(String string) {
        int n2 = string.length();
        int n3 = (int)((double)n2 * 1.1);
        StringBuilder stringBuilder = new StringBuilder(n3);
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            String string2 = JsonEscapeUtil.getObligatoryEscapeCode(c2);
            if (string2 == null) {
                stringBuilder.append(c2);
                continue;
            }
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    static {
        block7: for (char c2 = '\u0000'; c2 < ' '; c2 = (char)(c2 + '\u0001')) {
            switch (c2) {
                case '\b': {
                    JsonEscapeUtil.ESCAPE_CODES[c2] = "\\b";
                    continue block7;
                }
                case '\t': {
                    JsonEscapeUtil.ESCAPE_CODES[c2] = "\\t";
                    continue block7;
                }
                case '\n': {
                    JsonEscapeUtil.ESCAPE_CODES[c2] = "\\n";
                    continue block7;
                }
                case '\f': {
                    JsonEscapeUtil.ESCAPE_CODES[c2] = "\\f";
                    continue block7;
                }
                case '\r': {
                    JsonEscapeUtil.ESCAPE_CODES[c2] = "\\r";
                    continue block7;
                }
                default: {
                    char c3 = c2;
                    JsonEscapeUtil.ESCAPE_CODES[c3] = JsonEscapeUtil._computeEscapeCodeBelowASCII32(c3);
                }
            }
        }
    }
}

