/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.encoder;

import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.OutputStreamAppender;
import ch.qos.logback.core.encoder.EncoderBase;
import ch.qos.logback.core.spi.ContextAware;
import java.nio.charset.Charset;

public class LayoutWrappingEncoder<E>
extends EncoderBase<E> {
    protected Layout<E> layout;
    private Charset charset;
    ContextAware parent;
    Boolean immediateFlush = null;

    public Layout<E> getLayout() {
        return this.layout;
    }

    public void setLayout(Layout<E> layout) {
        this.layout = layout;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public void setImmediateFlush(boolean bl2) {
        this.addWarn("As of version 1.2.0 \"immediateFlush\" property should be set within the enclosing Appender.");
        this.addWarn("Please move \"immediateFlush\" property into the enclosing appender.");
        this.immediateFlush = bl2;
    }

    @Override
    public byte[] headerBytes() {
        if (this.layout == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        this.appendIfNotNull(stringBuilder, this.layout.getFileHeader());
        this.appendIfNotNull(stringBuilder, this.layout.getPresentationHeader());
        if (stringBuilder.length() > 0) {
            stringBuilder.append(CoreConstants.LINE_SEPARATOR);
        }
        return this.convertToBytes(stringBuilder.toString());
    }

    @Override
    public byte[] footerBytes() {
        if (this.layout == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        this.appendIfNotNull(stringBuilder, this.layout.getPresentationFooter());
        this.appendIfNotNull(stringBuilder, this.layout.getFileFooter());
        return this.convertToBytes(stringBuilder.toString());
    }

    private byte[] convertToBytes(String string) {
        if (this.charset == null) {
            return string.getBytes();
        }
        return string.getBytes(this.charset);
    }

    @Override
    public byte[] encode(E object) {
        object = this.layout.doLayout(object);
        return this.convertToBytes((String)object);
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public void start() {
        if (this.immediateFlush != null) {
            if (this.parent instanceof OutputStreamAppender) {
                LayoutWrappingEncoder layoutWrappingEncoder = this;
                layoutWrappingEncoder.addWarn("Setting the \"immediateFlush\" property of the enclosing appender to " + layoutWrappingEncoder.immediateFlush);
                OutputStreamAppender outputStreamAppender = (OutputStreamAppender)this.parent;
                outputStreamAppender.setImmediateFlush(this.immediateFlush);
            } else {
                this.addError("Could not set the \"immediateFlush\" property of the enclosing appender.");
            }
        }
        this.started = true;
    }

    @Override
    public void stop() {
        this.started = false;
    }

    private void appendIfNotNull(StringBuilder stringBuilder, String string) {
        if (string != null) {
            stringBuilder.append(string);
        }
    }

    public void setParent(ContextAware contextAware) {
        this.parent = contextAware;
    }
}

