/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.helpers;

import java.util.LinkedList;
import java.util.List;

public class ThrowableToStringArray {
    public static String[] convert(Throwable throwable) {
        LinkedList<String> linkedList = new LinkedList<String>();
        ThrowableToStringArray.extract(linkedList, throwable, null);
        return linkedList.toArray(new String[0]);
    }

    private static void extract(List<String> list, Throwable object, StackTraceElement[] object2) {
        while (true) {
            StackTraceElement[] stackTraceElementArray = object.getStackTrace();
            int n2 = ThrowableToStringArray.findNumberOfCommonFrames(stackTraceElementArray, object2);
            list.add(ThrowableToStringArray.formatFirstLine((Throwable)object, object2));
            for (int i2 = 0; i2 < stackTraceElementArray.length - n2; ++i2) {
                list.add("\tat " + stackTraceElementArray[i2].toString());
            }
            if (n2 != 0) {
                list.add("\t... " + n2 + " common frames omitted");
            }
            if ((object2 = object.getCause()) == null) break;
            Object object3 = object2;
            object2 = stackTraceElementArray;
            object = object3;
        }
    }

    private static String formatFirstLine(Throwable throwable, StackTraceElement[] object) {
        String string = "";
        if (object != null) {
            string = "Caused by: ";
        }
        object = string + throwable.getClass().getName();
        if (throwable.getMessage() != null) {
            object = (String)object + ": " + throwable.getMessage();
        }
        return object;
    }

    private static int findNumberOfCommonFrames(StackTraceElement[] stackTraceElementArray, StackTraceElement[] stackTraceElementArray2) {
        if (stackTraceElementArray2 == null) {
            return 0;
        }
        int n2 = stackTraceElementArray.length - 1;
        int n3 = 0;
        for (int i2 = stackTraceElementArray2.length - 1; n2 >= 0 && i2 >= 0 && stackTraceElementArray[n2].equals(stackTraceElementArray2[i2]); --n2, --i2) {
            ++n3;
        }
        return n3;
    }
}

