/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.action;

import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.spi.SaxEventInterpretationContext;
import ch.qos.logback.core.spi.ContextAware;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.util.OptionHelper;
import org.xml.sax.Attributes;

public class PreconditionValidator
extends ContextAwareBase {
    boolean valid = true;
    SaxEventInterpretationContext seic;
    Attributes attributes;
    String tag;

    public PreconditionValidator(ContextAware contextAware, SaxEventInterpretationContext saxEventInterpretationContext, String string, Attributes attributes) {
        super(contextAware);
        this.setContext(contextAware.getContext());
        this.seic = saxEventInterpretationContext;
        this.tag = string;
        this.attributes = attributes;
    }

    public PreconditionValidator validateZeroAttributes() {
        if (this.attributes == null) {
            return this;
        }
        if (this.attributes.getLength() != 0) {
            PreconditionValidator preconditionValidator = this;
            preconditionValidator.addError("Element [" + preconditionValidator.tag + "] should have no attributes, near line " + Action.getLineNumber(this.seic));
            this.valid = false;
        }
        return this;
    }

    public PreconditionValidator validateClassAttribute() {
        return this.validateGivenAttribute("class");
    }

    public PreconditionValidator validateNameAttribute() {
        return this.validateGivenAttribute("name");
    }

    public PreconditionValidator validateValueAttribute() {
        return this.validateGivenAttribute("value");
    }

    public PreconditionValidator validateRefAttribute() {
        return this.validateGivenAttribute("ref");
    }

    public boolean isInvalidAttribute(String string) {
        string = this.attributes.getValue(string);
        return OptionHelper.isNullOrEmptyOrAllSpaces(string);
    }

    public PreconditionValidator validateGivenAttribute(String string) {
        boolean bl2 = this.isInvalidAttribute(string);
        if (bl2) {
            this.addMissingAttributeError(string);
            this.valid = false;
        }
        return this;
    }

    @Deprecated
    public PreconditionValidator generic(String string) {
        return this.validateGivenAttribute(string);
    }

    public void addMissingAttributeError(String string) {
        this.addError("Missing attribute [" + string + "]. " + this.getLocationSuffix());
    }

    public String getLocationSuffix() {
        return "See element [" + this.tag + "] near line " + Action.getLineNumber(this.seic);
    }

    public boolean isValid() {
        return this.valid;
    }
}

