/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.action;

import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.spi.ActionException;
import ch.qos.logback.core.joran.spi.SaxEventInterpretationContext;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.ResourceModel;
import org.xml.sax.Attributes;

public abstract class ResourceAction
extends Action {
    private static final String FILE_ATTR = "file";
    private static final String URL_ATTR = "url";
    private static final String RESOURCE_ATTR = "resource";
    private static final String OPTIONAL_ATTR = "optional";
    Model parentModel;
    ResourceModel resourceModel;
    boolean inError = false;

    protected abstract ResourceModel makeNewResourceModel();

    @Override
    public void begin(SaxEventInterpretationContext saxEventInterpretationContext, String string, Attributes attributes) throws ActionException {
        String string2 = attributes.getValue(OPTIONAL_ATTR);
        this.resourceModel = this.makeNewResourceModel();
        this.resourceModel.setOptional(string2);
        ResourceAction resourceAction = this;
        resourceAction.fillInIncludeModelAttributes(resourceAction.resourceModel, string, attributes);
        if (!saxEventInterpretationContext.isModelStackEmpty()) {
            this.parentModel = saxEventInterpretationContext.peekModel();
        }
        int n2 = ResourceAction.getLineNumber(saxEventInterpretationContext);
        this.resourceModel.setLineNumber(n2);
        saxEventInterpretationContext.pushModel(this.resourceModel);
    }

    private void fillInIncludeModelAttributes(ResourceModel object, String string, Attributes object2) {
        this.resourceModel.setTag(string);
        object = object2.getValue(FILE_ATTR);
        string = object2.getValue(URL_ATTR);
        object2 = object2.getValue(RESOURCE_ATTR);
        this.resourceModel.setFile((String)object);
        this.resourceModel.setUrl(string);
        this.resourceModel.setResource((String)object2);
    }

    @Override
    public void end(SaxEventInterpretationContext saxEventInterpretationContext, String object) throws ActionException {
        if (this.inError) {
            return;
        }
        object = saxEventInterpretationContext.peekModel();
        if (object != this.resourceModel) {
            ResourceAction resourceAction = this;
            resourceAction.addWarn("The object at the of the stack is not the model [" + resourceAction.resourceModel.idString() + "] pushed earlier.");
            this.addWarn("This is wholly unexpected.");
        }
        if (this.parentModel != null) {
            this.parentModel.addSubModel(this.resourceModel);
            saxEventInterpretationContext.popModel();
        }
    }
}

