/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.event;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.event.BodyEvent;
import ch.qos.logback.core.joran.event.EndEvent;
import ch.qos.logback.core.joran.event.SaxEvent;
import ch.qos.logback.core.joran.event.StartEvent;
import ch.qos.logback.core.joran.spi.ElementPath;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.spi.ContextAware;
import ch.qos.logback.core.spi.ContextAwareImpl;
import ch.qos.logback.core.status.Status;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class SaxEventRecorder
extends DefaultHandler
implements ContextAware {
    final ContextAwareImpl contextAwareImpl;
    final ElementPath elementPath;
    List<SaxEvent> saxEventList = new ArrayList<SaxEvent>();
    Locator locator;

    public SaxEventRecorder(Context context) {
        this(context, new ElementPath());
    }

    public SaxEventRecorder(Context context, ElementPath elementPath) {
        this.contextAwareImpl = new ContextAwareImpl(context, this);
        this.elementPath = elementPath;
    }

    @Override
    public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
        this.addWarn("Document Type Declaration (DOCTYPE) with external file reference is");
        this.addWarn("disallowed to prevent Server-Side Request Forgery (SSRF) attacks.");
        this.addWarn("returning contents of SYSTEM " + string2 + " as a white space");
        return new InputSource(new ByteArrayInputStream(" ".getBytes()));
    }

    public final void recordEvents(InputStream inputStream) throws JoranException {
        this.recordEvents(new InputSource(inputStream));
    }

    public void recordEvents(InputSource inputSource) throws JoranException {
        SAXParser sAXParser = this.buildSaxParser();
        try {
            sAXParser.parse(inputSource, (DefaultHandler)this);
            return;
        }
        catch (IOException iOException) {
            this.handleError("I/O error occurred while parsing xml file", iOException);
        }
        catch (SAXException sAXException) {
            throw new JoranException("Problem parsing XML document. See previously reported errors.", sAXException);
        }
        catch (Exception exception) {
            this.handleError("Unexpected exception while parsing XML document.", exception);
        }
        throw new IllegalStateException("This point can never be reached");
    }

    private void handleError(String string, Throwable throwable) throws JoranException {
        this.addError(string, throwable);
        throw new JoranException(string, throwable);
    }

    private SAXParser buildSaxParser() throws JoranException {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setValidating(false);
            sAXParserFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            sAXParserFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            sAXParserFactory.setNamespaceAware(true);
            return sAXParserFactory.newSAXParser();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            String string = "Error during SAX paser configuration. See https://logback.qos.ch/codes.html#saxParserConfiguration";
            this.addError(string, parserConfigurationException);
            throw new JoranException(string, parserConfigurationException);
        }
        catch (SAXException sAXException) {
            String string = "Error during parser creation or parser configuration";
            this.addError(string, sAXException);
            throw new JoranException(string, sAXException);
        }
    }

    @Override
    public void startDocument() {
    }

    public Locator getLocator() {
        return this.locator;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    protected boolean shouldIgnoreForElementPath(String string) {
        return false;
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) {
        Object object = this.getTagName(string2, string3);
        if (!this.shouldIgnoreForElementPath((String)object)) {
            this.elementPath.push((String)object);
        }
        object = this.elementPath.duplicate();
        this.saxEventList.add(new StartEvent((ElementPath)object, string, string2, string3, attributes, this.getLocator()));
    }

    @Override
    public void characters(char[] object, int n2, int n3) {
        object = new String((char[])object, n2, n3);
        SaxEvent saxEvent = this.getLastEvent();
        if (saxEvent instanceof BodyEvent) {
            saxEvent = (BodyEvent)saxEvent;
            ((BodyEvent)saxEvent).append((String)object);
            return;
        }
        if (!this.isSpaceOnly((String)object)) {
            this.saxEventList.add(new BodyEvent((String)object, this.getLocator()));
        }
    }

    boolean isSpaceOnly(String string) {
        return (string = string.trim()).length() == 0;
    }

    SaxEvent getLastEvent() {
        if (this.saxEventList.isEmpty()) {
            return null;
        }
        int n2 = this.saxEventList.size();
        return this.saxEventList.get(n2 - 1);
    }

    @Override
    public void endElement(String string, String string2, String string3) {
        this.saxEventList.add(new EndEvent(string, string2, string3, this.getLocator()));
        string = this.getTagName(string2, string3);
        if (!this.shouldIgnoreForElementPath(string)) {
            this.elementPath.pop();
        }
    }

    String getTagName(String string, String string2) {
        if (string == null || string.length() <= 0) {
            string = string2;
        }
        return string;
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXException {
        this.addError("XML_PARSING - Parsing error on line " + sAXParseException.getLineNumber() + " and column " + sAXParseException.getColumnNumber());
        this.addError(sAXParseException.toString());
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.addError("XML_PARSING - Parsing fatal error on line " + sAXParseException.getLineNumber() + " and column " + sAXParseException.getColumnNumber());
        this.addError(sAXParseException.toString());
    }

    @Override
    public void warning(SAXParseException sAXParseException) throws SAXException {
        this.addWarn("XML_PARSING - Parsing warning on line " + sAXParseException.getLineNumber() + " and column " + sAXParseException.getColumnNumber(), sAXParseException);
    }

    @Override
    public void addError(String string) {
        this.contextAwareImpl.addError(string);
    }

    @Override
    public void addError(String string, Throwable throwable) {
        this.contextAwareImpl.addError(string, throwable);
    }

    @Override
    public void addInfo(String string) {
        this.contextAwareImpl.addInfo(string);
    }

    @Override
    public void addInfo(String string, Throwable throwable) {
        this.contextAwareImpl.addInfo(string, throwable);
    }

    @Override
    public void addStatus(Status status) {
        this.contextAwareImpl.addStatus(status);
    }

    @Override
    public void addWarn(String string) {
        this.contextAwareImpl.addWarn(string);
    }

    @Override
    public void addWarn(String string, Throwable throwable) {
        this.contextAwareImpl.addWarn(string, throwable);
    }

    @Override
    public Context getContext() {
        return this.contextAwareImpl.getContext();
    }

    @Override
    public void setContext(Context context) {
        this.contextAwareImpl.setContext(context);
    }

    public List<SaxEvent> getSaxEventList() {
        return this.saxEventList;
    }
}

