/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.spi;

import ch.qos.logback.core.joran.spi.HttpUtil;
import ch.qos.logback.core.joran.spi.HttpUtil$RequestMethod;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.util.MD5Util;
import java.io.File;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class ConfigurationWatchList
extends ContextAwareBase {
    public static final String HTTPS_PROTOCOL_STR = "https";
    public static final String HTTP_PROTOCOL_STR = "http";
    public static final String FILE_PROTOCOL_STR = "file";
    static final String[] WATCHABLE_PROTOCOLS = new String[]{"file", "https", "http"};
    static final byte[] BUF_ZERO = new byte[]{0};
    URL mainURL;
    List<File> fileWatchList = new ArrayList<File>();
    List<URL> urlWatchList = new ArrayList<URL>();
    List<byte[]> lastHashList = new ArrayList<byte[]>();
    List<Long> lastModifiedList = new ArrayList<Long>();

    public ConfigurationWatchList buildClone() {
        ConfigurationWatchList configurationWatchList = new ConfigurationWatchList();
        new ConfigurationWatchList().mainURL = this.mainURL;
        configurationWatchList.fileWatchList = new ArrayList<File>(this.fileWatchList);
        configurationWatchList.lastModifiedList = new ArrayList<Long>(this.lastModifiedList);
        configurationWatchList.lastHashList = new ArrayList<byte[]>(this.lastHashList);
        return configurationWatchList;
    }

    public void clear() {
        this.mainURL = null;
        this.lastModifiedList.clear();
        this.fileWatchList.clear();
        this.urlWatchList.clear();
        this.lastHashList.clear();
    }

    public void setMainURL(URL uRL) {
        this.mainURL = uRL;
        if (uRL != null) {
            this.addAsFileToWatch(uRL);
        }
    }

    public boolean watchPredicateFulfilled() {
        if (this.hasMainURLAndNonEmptyFileList()) {
            return true;
        }
        if (this.urlListContainsProperties()) {
            return true;
        }
        return this.fileWatchListContainsProperties();
    }

    private boolean urlListContainsProperties() {
        return this.urlWatchList.stream().anyMatch(uRL -> uRL.toString().endsWith(".properties"));
    }

    private boolean hasMainURLAndNonEmptyFileList() {
        return this.mainURL != null && !this.fileWatchList.isEmpty();
    }

    private boolean fileWatchListContainsProperties() {
        return this.fileWatchList.stream().anyMatch(file -> file.getName().endsWith(".properties"));
    }

    private void addAsFileToWatch(URL serializable) {
        if ((serializable = this.convertToFile((URL)serializable)) != null) {
            this.fileWatchList.add((File)serializable);
            this.lastModifiedList.add(((File)serializable).lastModified());
        }
    }

    private boolean isHTTP_Or_HTTPS(URL object) {
        object = ((URL)object).getProtocol();
        return this.isHTTP_Or_HTTPS((String)object);
    }

    private boolean isHTTP_Or_HTTPS(String string) {
        return string.equals(HTTP_PROTOCOL_STR) || string.equals(HTTPS_PROTOCOL_STR);
    }

    private void addAsHTTP_or_HTTPS_URLToWatch(URL uRL) {
        if (this.isHTTP_Or_HTTPS(uRL)) {
            this.urlWatchList.add(uRL);
            this.lastHashList.add(BUF_ZERO);
        }
    }

    public void addToWatchList(URL uRL) {
        String string = uRL.getProtocol();
        if (string.equals(FILE_PROTOCOL_STR)) {
            this.addAsFileToWatch(uRL);
            return;
        }
        if (this.isHTTP_Or_HTTPS(string)) {
            this.addAsHTTP_or_HTTPS_URLToWatch(uRL);
        }
    }

    public URL getMainURL() {
        return this.mainURL;
    }

    public List<File> getCopyOfFileWatchList() {
        return new ArrayList<File>(this.fileWatchList);
    }

    public boolean emptyWatchLists() {
        if (this.fileWatchList != null && !this.fileWatchList.isEmpty()) {
            return false;
        }
        return this.urlWatchList == null || this.urlWatchList.isEmpty();
    }

    public File changeDetected() {
        return this.changeDetectedInFile();
    }

    public File changeDetectedInFile() {
        int n2 = this.fileWatchList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            File file;
            long l2;
            long l3 = this.lastModifiedList.get(i2);
            if (l3 == (l2 = (file = this.fileWatchList.get(i2)).lastModified())) continue;
            this.lastModifiedList.set(i2, l2);
            return file;
        }
        return null;
    }

    public URL changeDetectedInURL() {
        int n2 = this.urlWatchList.size();
        if (n2 > 0) {
            byte[] byArray = this.lastHashList.get(0);
            URL uRL = this.urlWatchList.get(0);
            Object object = new HttpUtil(HttpUtil$RequestMethod.GET, uRL);
            HttpURLConnection httpURLConnection = ((HttpUtil)object).connectTextTxt();
            object = ((HttpUtil)object).readResponse(httpURLConnection);
            object = this.computeHash((String)object);
            if (byArray == BUF_ZERO) {
                this.lastHashList.set(0, (byte[])object);
                return null;
            }
            if (Arrays.equals(byArray, (byte[])object)) {
                return null;
            }
            this.lastHashList.set(0, (byte[])object);
            return uRL;
        }
        return null;
    }

    private byte[] computeHash(String object) {
        if (object == null || ((String)object).trim().length() == 0) {
            return null;
        }
        try {
            MD5Util mD5Util = new MD5Util();
            byte[] byArray = mD5Util.md5Hash((String)object);
            object = byArray;
            return byArray;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            this.addError("missing MD5 algorithm", noSuchAlgorithmException);
            return null;
        }
    }

    File convertToFile(URL uRL) {
        String string = uRL.getProtocol();
        if (FILE_PROTOCOL_STR.equals(string)) {
            return new File(URLDecoder.decode(uRL.getFile()));
        }
        this.addInfo("URL [" + String.valueOf(uRL) + "] is not of type file");
        return null;
    }

    public boolean hasAtLeastOneWatchableFile() {
        return !this.fileWatchList.isEmpty();
    }

    public static boolean isWatchableProtocol(URL object) {
        if (object == null) {
            return false;
        }
        object = ((URL)object).getProtocol();
        return ConfigurationWatchList.isWatchableProtocol((String)object);
    }

    public static boolean isWatchableProtocol(String string) {
        return Arrays.stream(WATCHABLE_PROTOCOLS).anyMatch(string2 -> string2.equalsIgnoreCase(string));
    }

    public String getUrlWatchListAsStr() {
        String string = this.urlWatchList.stream().map(URL::toString).collect(Collectors.joining(", "));
        return string;
    }

    public String getFileWatchListAsStr() {
        return this.fileWatchList.stream().map(File::getPath).collect(Collectors.joining(", "));
    }
}

