/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.model.processor;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.model.ImportModel;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.processor.ModelHandlerBase;
import ch.qos.logback.core.model.processor.ModelHandlerException;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.core.util.OptionHelper;

public class ImportModelHandler
extends ModelHandlerBase {
    public ImportModelHandler(Context context) {
        super(context);
    }

    public static ModelHandlerBase makeInstance(Context context, ModelInterpretationContext modelInterpretationContext) {
        return new ImportModelHandler(context);
    }

    protected Class<ImportModel> getSupportedModelClass() {
        return ImportModel.class;
    }

    @Override
    public void handle(ModelInterpretationContext modelInterpretationContext, Model object) throws ModelHandlerException {
        object = (ImportModel)object;
        if (OptionHelper.isNullOrEmptyOrAllSpaces((String)(object = ((ImportModel)object).getClassName()))) {
            this.addWarn("Empty className not allowed");
            return;
        }
        String string = this.extractStem((String)object);
        if (string == null) {
            this.addWarn("[" + (String)object + "] could not be imported due to incorrect format");
            return;
        }
        modelInterpretationContext.addImport(string, (String)object);
    }

    String extractStem(String string) {
        if (string == null) {
            return null;
        }
        int n2 = string.lastIndexOf(46);
        if (n2 == -1) {
            return null;
        }
        if (n2 + 1 == string.length()) {
            return null;
        }
        return string.substring(n2 + 1);
    }
}

