/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.model.processor;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.model.ResourceModel;
import ch.qos.logback.core.model.processor.ModelHandlerBase;
import ch.qos.logback.core.spi.ContextAwarePropertyContainer;
import ch.qos.logback.core.util.Loader;
import ch.qos.logback.core.util.OptionHelper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;

public abstract class ResourceHandlerBase
extends ModelHandlerBase {
    protected String attributeInUse;
    protected boolean optional;

    protected ResourceHandlerBase(Context context) {
        super(context);
    }

    protected InputStream openURL(URL uRL) {
        try {
            return uRL.openStream();
        }
        catch (IOException iOException) {
            this.warnIfRequired("Failed to open [" + uRL.toString() + "]");
            return null;
        }
    }

    protected boolean checkAttributes(ResourceModel object) {
        String string = ((ResourceModel)object).getFile();
        String string2 = ((ResourceModel)object).getUrl();
        object = ((ResourceModel)object).getResource();
        int n2 = 0;
        if (!OptionHelper.isNullOrEmptyOrAllSpaces(string)) {
            ++n2;
        }
        if (!OptionHelper.isNullOrEmptyOrAllSpaces(string2)) {
            ++n2;
        }
        if (!OptionHelper.isNullOrEmptyOrAllSpaces((String)object)) {
            ++n2;
        }
        if (n2 == 0) {
            this.addError("One of \"path\", \"resource\" or \"url\" attributes must be set.");
            return false;
        }
        if (n2 > 1) {
            this.addError("Only one of \"file\", \"url\" or \"resource\" attributes should be set.");
            return false;
        }
        if (n2 == 1) {
            return true;
        }
        throw new IllegalStateException("Count value [" + n2 + "] is not expected");
    }

    protected String getAttribureInUse() {
        return this.attributeInUse;
    }

    protected URL getInputURL(ContextAwarePropertyContainer contextAwarePropertyContainer, ResourceModel object) {
        String string = ((ResourceModel)object).getFile();
        String string2 = ((ResourceModel)object).getUrl();
        object = ((ResourceModel)object).getResource();
        if (!OptionHelper.isNullOrEmptyOrAllSpaces(string)) {
            this.attributeInUse = contextAwarePropertyContainer.subst(string);
            ResourceHandlerBase resourceHandlerBase = this;
            return resourceHandlerBase.filePathAsURL(resourceHandlerBase.attributeInUse);
        }
        if (!OptionHelper.isNullOrEmptyOrAllSpaces(string2)) {
            this.attributeInUse = contextAwarePropertyContainer.subst(string2);
            ResourceHandlerBase resourceHandlerBase = this;
            return resourceHandlerBase.attributeToURL(resourceHandlerBase.attributeInUse);
        }
        if (!OptionHelper.isNullOrEmptyOrAllSpaces((String)object)) {
            this.attributeInUse = contextAwarePropertyContainer.subst((String)object);
            ResourceHandlerBase resourceHandlerBase = this;
            return resourceHandlerBase.resourceAsURL(resourceHandlerBase.attributeInUse);
        }
        throw new IllegalStateException("A URL stream should have been returned at this stage");
    }

    protected URL filePathAsURL(String object) {
        object = new File((String)object).toURI();
        try {
            return ((URI)object).toURL();
        }
        catch (MalformedURLException malformedURLException) {
            object = malformedURLException;
            malformedURLException.printStackTrace();
            return null;
        }
    }

    protected URL attributeToURL(String object) {
        try {
            return new URL((String)object);
        }
        catch (MalformedURLException malformedURLException) {
            object = "URL [" + (String)object + "] is not well formed.";
            this.addError((String)object, malformedURLException);
            return null;
        }
    }

    protected URL resourceAsURL(String string) {
        URL uRL = Loader.getResourceBySelfClassLoader(string);
        if (uRL == null) {
            this.warnIfRequired("Could not find resource corresponding to [" + string + "]");
            return null;
        }
        return uRL;
    }

    protected void warnIfRequired(String string) {
        if (!this.optional) {
            this.addWarn(string);
        }
    }
}

