/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.model.processor;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.hook.DefaultShutdownHook;
import ch.qos.logback.core.hook.ShutdownHook;
import ch.qos.logback.core.hook.ShutdownHookBase;
import ch.qos.logback.core.model.ComponentModel;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.ShutdownHookModel;
import ch.qos.logback.core.model.processor.ModelHandlerBase;
import ch.qos.logback.core.model.processor.ModelHandlerException;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.core.util.ContextUtil;
import ch.qos.logback.core.util.DynamicClassLoadingException;
import ch.qos.logback.core.util.IncompatibleClassException;
import ch.qos.logback.core.util.OptionHelper;

public class ShutdownHookModelHandler
extends ModelHandlerBase {
    static final String OLD_SHUTDOWN_HOOK_CLASSNAME = "ch.qos.logback.core.hook.DelayingShutdownHook";
    static final String DEFAULT_SHUTDOWN_HOOK_CLASSNAME = DefaultShutdownHook.class.getName();
    public static final String RENAME_WARNING = "ch.qos.logback.core.hook.DelayingShutdownHook was renamed as " + DEFAULT_SHUTDOWN_HOOK_CLASSNAME;
    boolean inError = false;
    ShutdownHook hook = null;

    public ShutdownHookModelHandler(Context context) {
        super(context);
    }

    public static ModelHandlerBase makeInstance(Context context, ModelInterpretationContext modelInterpretationContext) {
        return new ShutdownHookModelHandler(context);
    }

    protected Class<ShutdownHookModel> getSupportedModelClass() {
        return ShutdownHookModel.class;
    }

    @Override
    public void handle(ModelInterpretationContext modelInterpretationContext, Model object) {
        object = (ShutdownHookModel)object;
        if (OptionHelper.isNullOrEmptyOrAllSpaces((String)(object = ((ComponentModel)object).getClassName()))) {
            object = DEFAULT_SHUTDOWN_HOOK_CLASSNAME;
            this.addInfo("Assuming className [" + (String)object + "]");
        } else if (((String)(object = modelInterpretationContext.getImport((String)object))).equals(OLD_SHUTDOWN_HOOK_CLASSNAME)) {
            object = DEFAULT_SHUTDOWN_HOOK_CLASSNAME;
            this.addWarn(RENAME_WARNING);
            this.addWarn("Please use the new class name");
        }
        this.addInfo("About to instantiate shutdown hook of type [" + (String)object + "]");
        try {
            this.hook = (ShutdownHookBase)OptionHelper.instantiateByClassName((String)object, ShutdownHookBase.class, this.context);
            this.hook.setContext(this.context);
        }
        catch (DynamicClassLoadingException | IncompatibleClassException exception) {
            this.addError("Could not create a shutdown hook of type [" + (String)object + "].", exception);
            this.inError = true;
            return;
        }
        modelInterpretationContext.pushObject(this.hook);
    }

    @Override
    public void postHandle(ModelInterpretationContext modelInterpretationContext, Model object) throws ModelHandlerException {
        if (this.inError) {
            return;
        }
        object = modelInterpretationContext.peekObject();
        if (object != this.hook) {
            this.addWarn("The object on the top the of the stack is not the hook object pushed earlier.");
            return;
        }
        object = new ContextUtil(this.context);
        ((ContextUtil)object).addOrReplaceShutdownHook(this.hook);
        modelInterpretationContext.popObject();
    }
}

