/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.model.util;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.spi.ContextAwarePropertyContainer;
import ch.qos.logback.core.spi.ScanException;
import ch.qos.logback.core.util.OptionHelper;
import java.util.HashMap;
import java.util.Map;

public class VariableSubstitutionsHelper
extends ContextAwareBase
implements ContextAwarePropertyContainer {
    protected Map<String, String> propertiesMap;

    public VariableSubstitutionsHelper(Context context) {
        this.setContext(context);
        this.propertiesMap = new HashMap<String, String>();
    }

    public VariableSubstitutionsHelper(Context context, Map<String, String> map) {
        this.setContext(context);
        this.propertiesMap = new HashMap<String, String>(map);
    }

    @Override
    public String subst(String string) {
        if (string == null) {
            return null;
        }
        try {
            VariableSubstitutionsHelper variableSubstitutionsHelper = this;
            return OptionHelper.substVars(string, variableSubstitutionsHelper, variableSubstitutionsHelper.context);
        }
        catch (ScanException | IllegalArgumentException exception) {
            this.addError("Problem while parsing [" + string + "]", exception);
            return string;
        }
    }

    @Override
    public void addSubstitutionProperty(String string, String string2) {
        if (string == null || string2 == null) {
            return;
        }
        string2 = string2.trim();
        this.propertiesMap.put(string, string2);
    }

    @Override
    public String getProperty(String string) {
        return this.propertiesMap.get(string);
    }

    @Override
    public Map<String, String> getCopyOfPropertyMap() {
        return new HashMap<String, String>(this.propertiesMap);
    }
}

