/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.net.server;

import ch.qos.logback.core.net.server.Client;
import ch.qos.logback.core.net.server.ClientVisitor;
import ch.qos.logback.core.net.server.ConcurrentServerRunner$1;
import ch.qos.logback.core.net.server.ConcurrentServerRunner$ClientWrapper;
import ch.qos.logback.core.net.server.ServerListener;
import ch.qos.logback.core.net.server.ServerRunner;
import ch.qos.logback.core.spi.ContextAwareBase;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public abstract class ConcurrentServerRunner<T extends Client>
extends ContextAwareBase
implements ServerRunner<T>,
Runnable {
    private final Lock clientsLock = new ReentrantLock();
    private final Collection<T> clients = new ArrayList<T>();
    private final ServerListener<T> listener;
    private final Executor executor;
    private boolean running;

    public ConcurrentServerRunner(ServerListener<T> serverListener, Executor executor) {
        this.listener = serverListener;
        this.executor = executor;
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    protected void setRunning(boolean bl2) {
        this.running = bl2;
    }

    @Override
    public void stop() throws IOException {
        this.listener.close();
        this.accept(new ConcurrentServerRunner$1(this));
    }

    @Override
    public void accept(ClientVisitor<T> clientVisitor) {
        Object object = this.copyClients();
        object = object.iterator();
        while (object.hasNext()) {
            Client client = (Client)object.next();
            try {
                clientVisitor.visit(client);
            }
            catch (RuntimeException runtimeException) {
                this.addError(String.valueOf(client) + ": " + String.valueOf(runtimeException));
            }
        }
    }

    private Collection<T> copyClients() {
        this.clientsLock.lock();
        try {
            ArrayList<T> arrayList = new ArrayList<T>(this.clients);
            return arrayList;
        }
        finally {
            this.clientsLock.unlock();
        }
    }

    @Override
    public void run() {
        this.setRunning(true);
        try {
            ConcurrentServerRunner concurrentServerRunner = this;
            concurrentServerRunner.addInfo("listening on " + String.valueOf(concurrentServerRunner.listener));
            while (!Thread.currentThread().isInterrupted()) {
                T t2 = this.listener.acceptClient();
                if (!this.configureClient(t2)) {
                    this.addError(String.valueOf(t2) + ": connection dropped");
                    t2.close();
                    continue;
                }
                try {
                    this.executor.execute(new ConcurrentServerRunner$ClientWrapper(this, t2));
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    this.addError(String.valueOf(t2) + ": connection dropped");
                    t2.close();
                }
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Exception exception) {
            this.addError("listener: " + String.valueOf(exception));
        }
        this.setRunning(false);
        this.addInfo("shutting down");
        this.listener.close();
    }

    protected abstract boolean configureClient(T var1);

    private void addClient(T t2) {
        this.clientsLock.lock();
        try {
            this.clients.add(t2);
            return;
        }
        finally {
            this.clientsLock.unlock();
        }
    }

    private void removeClient(T t2) {
        this.clientsLock.lock();
        try {
            this.clients.remove(t2);
            return;
        }
        finally {
            this.clientsLock.unlock();
        }
    }
}

