/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.net.server;

import ch.qos.logback.core.net.server.Client;
import ch.qos.logback.core.net.server.ServerListener;
import ch.qos.logback.core.util.CloseUtil;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;

public abstract class ServerSocketListener<T extends Client>
implements ServerListener<T> {
    private final ServerSocket serverSocket;

    public ServerSocketListener(ServerSocket serverSocket) {
        this.serverSocket = serverSocket;
    }

    @Override
    public T acceptClient() throws IOException {
        Socket socket = this.serverSocket.accept();
        ServerSocketListener serverSocketListener = this;
        return serverSocketListener.createClient(serverSocketListener.socketAddressToString(socket.getRemoteSocketAddress()), socket);
    }

    protected abstract T createClient(String var1, Socket var2) throws IOException;

    @Override
    public void close() {
        CloseUtil.closeQuietly(this.serverSocket);
    }

    public String toString() {
        ServerSocketListener serverSocketListener = this;
        return serverSocketListener.socketAddressToString(serverSocketListener.serverSocket.getLocalSocketAddress());
    }

    private String socketAddressToString(SocketAddress object) {
        int n2 = ((String)(object = object.toString())).indexOf("/");
        if (n2 >= 0) {
            object = ((String)object).substring(n2 + 1);
        }
        return object;
    }
}

