/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.net.ssl;

import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;

public class SecureRandomFactoryBean {
    private String algorithm;
    private String provider;

    public SecureRandom createSecureRandom() throws NoSuchProviderException, NoSuchAlgorithmException {
        try {
            if (this.getProvider() != null) {
                return SecureRandom.getInstance(this.getAlgorithm(), this.getProvider());
            }
            return SecureRandom.getInstance(this.getAlgorithm());
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new NoSuchProviderException("no such secure random provider: " + this.getProvider());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new NoSuchAlgorithmException("no such secure random algorithm: " + this.getAlgorithm());
        }
    }

    public String getAlgorithm() {
        if (this.algorithm == null) {
            return "SHA1PRNG";
        }
        return this.algorithm;
    }

    public void setAlgorithm(String string) {
        this.algorithm = string;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String string) {
        this.provider = string;
    }
}

