/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.pattern.parser;

import ch.qos.logback.core.pattern.parser.OptionTokenizer;
import ch.qos.logback.core.pattern.parser.Token;
import ch.qos.logback.core.pattern.parser.TokenStream$TokenizerState;
import ch.qos.logback.core.pattern.util.IEscapeUtil;
import ch.qos.logback.core.pattern.util.RegularEscapeUtil;
import ch.qos.logback.core.pattern.util.RestrictedEscapeUtil;
import ch.qos.logback.core.spi.ScanException;
import java.util.ArrayList;
import java.util.List;

class TokenStream {
    final String pattern;
    final int patternLength;
    final IEscapeUtil escapeUtil;
    final IEscapeUtil optionEscapeUtil = new RestrictedEscapeUtil();
    TokenStream$TokenizerState state = TokenStream$TokenizerState.LITERAL_STATE;
    int pointer = 0;

    TokenStream(String string) {
        this(string, new RegularEscapeUtil());
    }

    TokenStream(String string, IEscapeUtil iEscapeUtil) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("null or empty pattern string not allowed");
        }
        this.pattern = string;
        this.patternLength = string.length();
        this.escapeUtil = iEscapeUtil;
    }

    List<Token> tokenize() throws ScanException {
        ArrayList<Token> arrayList = new ArrayList<Token>();
        StringBuffer stringBuffer = new StringBuffer();
        while (this.pointer < this.patternLength) {
            char c2 = this.pattern.charAt(this.pointer);
            ++this.pointer;
            switch (this.state.ordinal()) {
                case 0: {
                    this.handleLiteralState(c2, arrayList, stringBuffer);
                    break;
                }
                case 1: {
                    this.handleFormatModifierState(c2, arrayList, stringBuffer);
                    break;
                }
                case 3: {
                    this.processOption(c2, arrayList, stringBuffer);
                    break;
                }
                case 2: {
                    this.handleKeywordState(c2, arrayList, stringBuffer);
                    break;
                }
                case 4: {
                    this.handleRightParenthesisState(c2, arrayList, stringBuffer);
                }
            }
        }
        switch (this.state.ordinal()) {
            case 0: {
                this.addValuedToken(1000, stringBuffer, arrayList);
                break;
            }
            case 2: {
                arrayList.add(new Token(1004, stringBuffer.toString()));
                break;
            }
            case 4: {
                arrayList.add(Token.RIGHT_PARENTHESIS_TOKEN);
                break;
            }
            case 1: 
            case 3: {
                throw new ScanException("Unexpected end of pattern string");
            }
        }
        return arrayList;
    }

    private void handleRightParenthesisState(char c2, List<Token> list, StringBuffer stringBuffer) {
        list.add(Token.RIGHT_PARENTHESIS_TOKEN);
        switch (c2) {
            case ')': {
                return;
            }
            case '{': {
                this.state = TokenStream$TokenizerState.OPTION_STATE;
                return;
            }
            case '\\': {
                this.escape("%{}", stringBuffer);
                this.state = TokenStream$TokenizerState.LITERAL_STATE;
                return;
            }
        }
        stringBuffer.append(c2);
        this.state = TokenStream$TokenizerState.LITERAL_STATE;
    }

    private void processOption(char c2, List<Token> list, StringBuffer object) throws ScanException {
        object = new OptionTokenizer(this);
        ((OptionTokenizer)object).tokenize(c2, list);
    }

    private void handleFormatModifierState(char c2, List<Token> list, StringBuffer stringBuffer) {
        if (c2 == '(') {
            this.addValuedToken(1002, stringBuffer, list);
            list.add(Token.BARE_COMPOSITE_KEYWORD_TOKEN);
            this.state = TokenStream$TokenizerState.LITERAL_STATE;
            return;
        }
        if (Character.isJavaIdentifierStart(c2)) {
            this.addValuedToken(1002, stringBuffer, list);
            this.state = TokenStream$TokenizerState.KEYWORD_STATE;
            stringBuffer.append(c2);
            return;
        }
        stringBuffer.append(c2);
    }

    private void handleLiteralState(char c2, List<Token> list, StringBuffer stringBuffer) {
        switch (c2) {
            case '\\': {
                this.escape("%()", stringBuffer);
                return;
            }
            case '%': {
                this.addValuedToken(1000, stringBuffer, list);
                list.add(Token.PERCENT_TOKEN);
                this.state = TokenStream$TokenizerState.FORMAT_MODIFIER_STATE;
                return;
            }
            case ')': {
                this.addValuedToken(1000, stringBuffer, list);
                this.state = TokenStream$TokenizerState.RIGHT_PARENTHESIS_STATE;
                return;
            }
        }
        stringBuffer.append(c2);
    }

    private void handleKeywordState(char c2, List<Token> list, StringBuffer stringBuffer) {
        if (Character.isJavaIdentifierPart(c2)) {
            stringBuffer.append(c2);
            return;
        }
        if (c2 == '{') {
            this.addValuedToken(1004, stringBuffer, list);
            this.state = TokenStream$TokenizerState.OPTION_STATE;
            return;
        }
        if (c2 == '(') {
            this.addValuedToken(1005, stringBuffer, list);
        } else {
            if (c2 == '%') {
                this.addValuedToken(1004, stringBuffer, list);
                list.add(Token.PERCENT_TOKEN);
                this.state = TokenStream$TokenizerState.FORMAT_MODIFIER_STATE;
                return;
            }
            if (c2 == ')') {
                this.addValuedToken(1004, stringBuffer, list);
                this.state = TokenStream$TokenizerState.RIGHT_PARENTHESIS_STATE;
                return;
            }
            this.addValuedToken(1004, stringBuffer, list);
            if (c2 == '\\') {
                if (this.pointer < this.patternLength) {
                    c2 = this.pattern.charAt(this.pointer++);
                    this.escapeUtil.escape("%()", stringBuffer, c2, this.pointer);
                }
            } else {
                stringBuffer.append(c2);
            }
        }
        this.state = TokenStream$TokenizerState.LITERAL_STATE;
    }

    void escape(String string, StringBuffer stringBuffer) {
        if (this.pointer < this.patternLength) {
            char c2 = this.pattern.charAt(this.pointer++);
            this.escapeUtil.escape(string, stringBuffer, c2, this.pointer);
        }
    }

    void optionEscape(String string, StringBuffer stringBuffer) {
        if (this.pointer < this.patternLength) {
            char c2 = this.pattern.charAt(this.pointer++);
            this.optionEscapeUtil.escape(string, stringBuffer, c2, this.pointer);
        }
    }

    private void addValuedToken(int n2, StringBuffer stringBuffer, List<Token> list) {
        if (stringBuffer.length() > 0) {
            list.add(new Token(n2, stringBuffer.toString()));
            stringBuffer.setLength(0);
        }
    }
}

